<p>
  <strong>
    <a href="ACQUISITION.md">
      Open to Acquisition 🟢
    </a>
  </strong>
</p>

---

# Acquisition

## Why Is This Project Open to Acquisition?

Plaiceholder is a labour of love by [Joe Bell][twitter] – a quest for **the** perfect "low quality image placeholder" (LQIP) solution.

[Joe][twitter] loves to maintain and innovate the project, but is held by the constraints of his day-to-day work and limited free time.

Under a new ownership, Plaiceholder could:

- Innovate at a more consistent and faster pace
- Attract more consumers and contributors
- Attract more customers to your product/business (see below)

## Why Should You Acquire This Project?

> TL;DR If you're a content API or image storage solution, this project is for you.

Content APIs and image storage solutions with on-the-fly image optimization services are growing in popularity, for a good reason; enabling developers to build high-performance pages quickly, with faster build-times.

A lot of these providers don't take into account LQIP generation; which could be fetched on the server/build-time to improve the perceived performance of images used. Plaiceholder's open-source functions could be used under-the-hood to provide that unique functionality, and help you to attract more developers/customers to your service.

## What's Included?

Plaiceholder as a whole consists of 2 projects:

1. **[`plaiceholder`][repo]** (public)  
   Open-source functions for creating beautifully lightweight placeholders
2. **`plaiceholder.co`** (private)  
   Web application for sponsors ("pro") users to create LQIPs via the "studio" GUI.
   - Built with [Next.js](https://nextjs.org/) and [Chakra UI](https://chakra-ui.com/)
   - Deployed to [Vercel](https://vercel.com/)
   - Authentication/Backend handled by [Supabase](https://app.supabase.io/)
   - Payments handled by [Paddle](https://paddle.com/)
   - Analytics via [Plausible](https://plausible.io/)

## Terms

- All open-source code **must** remain open-source
- Stock options will be considered dependent on the company, but a cash sale (as a B2B transaction) is preferred.

## Contact Details

**Joe Bell**  
Twitter: [@joebell\_][twitter]  
Email: [joe@bigattic.com][email]

[twitter]: https://twitter.com/joebell_
[email]: mailto:joe@bigattic.com
[repo]: https://github.com/joe-bell/plaiceholder
[site]: https://plaiceholder.co
