# Generated by Django 4.2.23 on 2025-10-16 17:12

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wiki", "0018_alter_document_restrict_to_groups"),
    ]

    operations = [
        migrations.CreateModel(
            name="PinnedArticleConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "title",
                    models.CharField(max_length=255),
                ),
                (
                    "use_for_home_page",
                    models.BooleanField(default=False),
                ),
                (
                    "pinned_articles",
                    models.ManyToManyField(
                        limit_choices_to=models.Q(("parent__isnull", True)), to="wiki.document"
                    ),
                ),
            ],
            options={
                "verbose_name": "Pinned Article Configuration",
                "ordering": ("title", "id"),
            },
        ),
        migrations.AddConstraint(
            model_name="pinnedarticleconfig",
            constraint=models.UniqueConstraint(
                models.Value(1, output_field=models.IntegerField()),
                condition=models.Q(("use_for_home_page", True)),
                name="unique_pinned_article_config_home_page",
            ),
        ),
    ]
