# Generated by Django 4.1.7 on 2023-04-18 15:51

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import kitsune.search.models
import kitsune.sumo.models
import kitsune.tags.models
import kitsune.wiki.permissions


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("products", "0001_squashed_0005_auto_20200629_0826"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("taggit", "0001_initial"),
        ("gallery", "0001_squashed_0009_auto_20220107_0617"),
    ]

    operations = [
        migrations.CreateModel(
            name="Document",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(db_index=True, max_length=255)),
                ("slug", models.CharField(db_index=True, max_length=255)),
                ("is_template", models.BooleanField(db_index=True, default=False, editable=False)),
                ("is_localizable", models.BooleanField(db_index=True, default=True)),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            (b"af", "Afrikaans"),
                            (b"ar", "عربي"),
                            (b"az", "Azərbaycanca"),
                            (b"bg", "Български"),
                            (b"bn-BD", "বাংলা (বাংলাদেশ)"),
                            (b"bn-IN", "বাংলা (ভারত)"),
                            (b"bs", "Bosanski"),
                            (b"ca", "català"),
                            (b"cs", "Čeština"),
                            (b"da", "Dansk"),
                            (b"de", "Deutsch"),
                            (b"ee", "Èʋegbe"),
                            (b"el", "Ελληνικά"),
                            (b"en-US", "English"),
                            (b"es", "Español"),
                            (b"et", "eesti keel"),
                            (b"eu", "Euskara"),
                            (b"fa", "فارسی"),
                            (b"fi", "suomi"),
                            (b"fr", "Français"),
                            (b"fy-NL", "Frysk"),
                            (b"ga-IE", "Gaeilge (Éire)"),
                            (b"gl", "Galego"),
                            (b"gu-IN", "ગુજરાતી"),
                            (b"ha", "هَرْشَن هَوْسَ"),
                            (b"he", "עברית"),
                            (b"hi-IN", "हिन्दी (भारत)"),
                            (b"hr", "Hrvatski"),
                            (b"hu", "Magyar"),
                            (b"id", "Bahasa Indonesia"),
                            (b"ig", "Asụsụ Igbo"),
                            (b"it", "Italiano"),
                            (b"ja", "日本語"),
                            (b"km", "ខ្មែរ"),
                            (b"ko", "한국어"),
                            (b"ln", "Lingála"),
                            (b"lt", "lietuvių kalba"),
                            (b"ne-NP", "नेपाली"),
                            (b"nl", "Nederlands"),
                            (b"no", "Norsk"),
                            (b"pl", "Polski"),
                            (b"pt-BR", "Português (do Brasil)"),
                            (b"pt-PT", "Português (Europeu)"),
                            (b"ro", "română"),
                            (b"ru", "Русский"),
                            (b"si", "සිංහල"),
                            (b"sk", "slovenčina"),
                            (b"sl", "slovenščina"),
                            (b"sq", "Shqip"),
                            (b"sr-Cyrl", "Српски"),
                            (b"sw", "Kiswahili"),
                            (b"sv", "Svenska"),
                            (b"ta", "தமிழ்"),
                            (b"ta-LK", "தமிழ் (இலங்கை)"),
                            (b"te", "తెలుగు"),
                            (b"th", "ไทย"),
                            (b"tr", "Türkçe"),
                            (b"uk", "Українська"),
                            (b"ur", "اُردو"),
                            (b"vi", "Tiếng Việt"),
                            (b"wo", "Wolof"),
                            (b"xh", "isiXhosa"),
                            (b"yo", "èdè Yorùbá"),
                            (b"zh-CN", "中文 (简体)"),
                            (b"zh-TW", "正體中文 (繁體)"),
                            (b"zu", "isiZulu"),
                        ],
                        db_index=True,
                        default=b"en-US",
                        max_length=7,
                    ),
                ),
                ("html", models.TextField(editable=False)),
                (
                    "category",
                    models.IntegerField(
                        choices=[
                            (10, "Troubleshooting"),
                            (20, "How to"),
                            (30, "How to contribute"),
                            (40, "Administration"),
                            (50, "Navigation"),
                            (60, "Templates"),
                            (70, "Canned Responses"),
                        ],
                        db_index=True,
                    ),
                ),
                (
                    "is_archived",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="If checked, this wiki page will be hidden from basic searches and dashboards. When viewed, the page will warn that it is no longer maintained.",
                        verbose_name=b"is obsolete",
                    ),
                ),
                (
                    "allow_discussion",
                    models.BooleanField(
                        default=True,
                        help_text="If checked, this document allows discussion in an associated forum. Uncheck to hide/disable the forum.",
                    ),
                ),
                (
                    "needs_change",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="If checked, this document needs updates.",
                    ),
                ),
                ("needs_change_comment", models.CharField(blank=True, max_length=500)),
                ("share_link", models.CharField(default=b"", max_length=24)),
                ("display_order", models.IntegerField(db_index=True, default=1)),
                ("contributors", models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "permissions": [
                    ("archive_document", "Can archive document"),
                    ("edit_needs_change", "Can edit needs_change"),
                ],
            },
            bases=(
                models.Model,
                kitsune.search.models.SearchMixin,
                kitsune.wiki.permissions.DocumentPermissionMixin,
            ),
        ),
        migrations.CreateModel(
            name="Revision",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("summary", models.TextField()),
                ("content", models.TextField()),
                ("keywords", models.CharField(blank=True, max_length=255)),
                ("created", models.DateTimeField(default=datetime.datetime.now)),
                ("reviewed", models.DateTimeField(null=True)),
                ("expires", models.DateTimeField(blank=True, null=True)),
                (
                    "significance",
                    models.IntegerField(
                        choices=[
                            (10, "Minor details that don't affect the instructions"),
                            (20, "Content changes that don't require immediate translation"),
                            (
                                30,
                                "Major content changes that will make older translations inaccurate",
                            ),
                        ],
                        null=True,
                    ),
                ),
                ("comment", models.CharField(max_length=255)),
                ("is_approved", models.BooleanField(db_index=True, default=False)),
                ("is_ready_for_localization", models.BooleanField(default=False)),
                ("readied_for_localization", models.DateTimeField(null=True)),
                (
                    "based_on",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wiki.revision",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_%(class)ss",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="revisions",
                        to="wiki.document",
                    ),
                ),
                (
                    "readied_for_localization_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="readied_for_l10n_revisions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "reviewer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reviewed_revisions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "permissions": [
                    ("review_revision", "Can review a revision"),
                    ("mark_ready_for_l10n", "Can mark revision as ready for localization"),
                    ("edit_keywords", "Can edit keywords"),
                ],
            },
            bases=(models.Model, kitsune.search.models.SearchMixin),
        ),
        migrations.CreateModel(
            name="HelpfulVote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("helpful", models.BooleanField(default=False)),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("anonymous_id", models.CharField(db_index=True, max_length=40)),
                ("user_agent", models.CharField(max_length=1000)),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="poll_votes",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "revision",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="poll_votes",
                        to="wiki.revision",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentImage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="wiki.document"
                    ),
                ),
                (
                    "image",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="gallery.image"
                    ),
                ),
            ],
            options={
                "unique_together": {("document", "image")},
            },
        ),
        migrations.AddField(
            model_name="document",
            name="current_revision",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="current_for+",
                to="wiki.revision",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="latest_localizable_revision",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="localizable_for+",
                to="wiki.revision",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="translations",
                to="wiki.document",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="products",
            field=models.ManyToManyField(to="products.product"),
        ),
        migrations.AddField(
            model_name="document",
            name="tags",
            field=kitsune.tags.models.BigVocabTaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="topics",
            field=models.ManyToManyField(to="products.topic"),
        ),
        migrations.AlterUniqueTogether(
            name="document",
            unique_together={("slug", "locale"), ("title", "locale"), ("parent", "locale")},
        ),
        migrations.AlterModelOptions(
            name="document",
            options={
                "ordering": ["display_order", "id"],
                "permissions": [
                    ("archive_document", "Can archive document"),
                    ("edit_needs_change", "Can edit needs_change"),
                ],
            },
        ),
        migrations.AlterField(
            model_name="document",
            name="locale",
            field=kitsune.sumo.models.LocaleField(
                choices=[
                    (b"af", "Afrikaans"),
                    (b"ar", "عربي"),
                    (b"az", "Azərbaycanca"),
                    (b"bg", "Български"),
                    (b"bn-BD", "বাংলা (বাংলাদেশ)"),
                    (b"bn-IN", "বাংলা (ভারত)"),
                    (b"bs", "Bosanski"),
                    (b"ca", "català"),
                    (b"cs", "Čeština"),
                    (b"da", "Dansk"),
                    (b"de", "Deutsch"),
                    (b"ee", "Èʋegbe"),
                    (b"el", "Ελληνικά"),
                    (b"en-US", "English"),
                    (b"es", "Español"),
                    (b"et", "eesti keel"),
                    (b"eu", "Euskara"),
                    (b"fa", "فارسی"),
                    (b"fi", "suomi"),
                    (b"fr", "Français"),
                    (b"fy-NL", "Frysk"),
                    (b"ga-IE", "Gaeilge (Éire)"),
                    (b"gl", "Galego"),
                    (b"gu-IN", "ગુજરાતી"),
                    (b"ha", "هَرْشَن هَوْسَ"),
                    (b"he", "עברית"),
                    (b"hi-IN", "हिन्दी (भारत)"),
                    (b"hr", "Hrvatski"),
                    (b"hu", "Magyar"),
                    (b"id", "Bahasa Indonesia"),
                    (b"ig", "Asụsụ Igbo"),
                    (b"it", "Italiano"),
                    (b"ja", "日本語"),
                    (b"km", "ខ្មែរ"),
                    (b"kn", "ಕನ್ನಡ"),
                    (b"ko", "한국어"),
                    (b"ln", "Lingála"),
                    (b"lt", "lietuvių kalba"),
                    (b"ml", "മലയാളം"),
                    (b"ne-NP", "नेपाली"),
                    (b"nl", "Nederlands"),
                    (b"no", "Norsk"),
                    (b"pl", "Polski"),
                    (b"pt-BR", "Português (do Brasil)"),
                    (b"pt-PT", "Português (Europeu)"),
                    (b"ro", "română"),
                    (b"ru", "Русский"),
                    (b"si", "සිංහල"),
                    (b"sk", "slovenčina"),
                    (b"sl", "slovenščina"),
                    (b"sq", "Shqip"),
                    (b"sr-Cyrl", "Српски"),
                    (b"sw", "Kiswahili"),
                    (b"sv", "Svenska"),
                    (b"ta", "தமிழ்"),
                    (b"ta-LK", "தமிழ் (இலங்கை)"),
                    (b"te", "తెలుగు"),
                    (b"th", "ไทย"),
                    (b"tr", "Türkçe"),
                    (b"uk", "Українська"),
                    (b"ur", "اُردو"),
                    (b"vi", "Tiếng Việt"),
                    (b"wo", "Wolof"),
                    (b"xh", "isiXhosa"),
                    (b"yo", "èdè Yorùbá"),
                    (b"zh-CN", "中文 (简体)"),
                    (b"zh-TW", "正體中文 (繁體)"),
                    (b"zu", "isiZulu"),
                ],
                db_index=True,
                default=b"en-US",
                max_length=7,
            ),
        ),
        migrations.CreateModel(
            name="HelpfulVoteMetadata",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("key", models.CharField(db_index=True, max_length=40)),
                ("value", models.CharField(max_length=1000)),
                (
                    "vote",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata",
                        to="wiki.helpfulvote",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="document",
            name="related_documents",
            field=models.ManyToManyField(
                blank=True, related_name="related_documents_rel_+", to="wiki.document"
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="locale",
            field=kitsune.sumo.models.LocaleField(
                choices=[
                    (b"af", "Afrikaans"),
                    (b"ar", "عربي"),
                    (b"az", "Azərbaycanca"),
                    (b"bg", "Български"),
                    (b"bm", "Bamanankan"),
                    (b"bn-BD", "বাংলা (বাংলাদেশ)"),
                    (b"bn-IN", "বাংলা (ভারত)"),
                    (b"bs", "Bosanski"),
                    (b"ca", "català"),
                    (b"cs", "Čeština"),
                    (b"da", "Dansk"),
                    (b"de", "Deutsch"),
                    (b"ee", "Èʋegbe"),
                    (b"el", "Ελληνικά"),
                    (b"en-US", "English"),
                    (b"es", "Español"),
                    (b"et", "eesti keel"),
                    (b"eu", "Euskara"),
                    (b"fa", "فارسی"),
                    (b"fi", "suomi"),
                    (b"fr", "Français"),
                    (b"fy-NL", "Frysk"),
                    (b"ga-IE", "Gaeilge (Éire)"),
                    (b"gl", "Galego"),
                    (b"gu-IN", "ગુજરાતી"),
                    (b"ha", "هَرْشَن هَوْسَ"),
                    (b"he", "עברית"),
                    (b"hi-IN", "हिन्दी (भारत)"),
                    (b"hr", "Hrvatski"),
                    (b"hu", "Magyar"),
                    (b"dsb", "Dolnoserbšćina"),
                    (b"hsb", "Hornjoserbsce"),
                    (b"id", "Bahasa Indonesia"),
                    (b"ig", "Asụsụ Igbo"),
                    (b"it", "Italiano"),
                    (b"ja", "日本語"),
                    (b"km", "ខ្មែរ"),
                    (b"kn", "ಕನ್ನಡ"),
                    (b"ko", "한국어"),
                    (b"ln", "Lingála"),
                    (b"lt", "lietuvių kalba"),
                    (b"mg", "Malagasy"),
                    (b"mk", "Македонски"),
                    (b"ml", "മലയാളം"),
                    (b"ne-NP", "नेपाली"),
                    (b"nl", "Nederlands"),
                    (b"no", "Norsk"),
                    (b"pl", "Polski"),
                    (b"pt-BR", "Português (do Brasil)"),
                    (b"pt-PT", "Português (Europeu)"),
                    (b"ro", "română"),
                    (b"ru", "Русский"),
                    (b"si", "සිංහල"),
                    (b"sk", "slovenčina"),
                    (b"sl", "slovenščina"),
                    (b"sq", "Shqip"),
                    (b"sr", "Српски"),
                    (b"sw", "Kiswahili"),
                    (b"sv", "Svenska"),
                    (b"ta", "தமிழ்"),
                    (b"ta-LK", "தமிழ் (இலங்கை)"),
                    (b"te", "తెలుగు"),
                    (b"th", "ไทย"),
                    (b"tn", "Setswana"),
                    (b"tr", "Türkçe"),
                    (b"uk", "Українська"),
                    (b"ur", "اُردو"),
                    (b"vi", "Tiếng Việt"),
                    (b"wo", "Wolof"),
                    (b"xh", "isiXhosa"),
                    (b"yo", "èdè Yorùbá"),
                    (b"zh-CN", "中文 (简体)"),
                    (b"zh-TW", "正體中文 (繁體)"),
                    (b"zu", "isiZulu"),
                ],
                db_index=True,
                default=b"en-US",
                max_length=7,
            ),
        ),
        migrations.CreateModel(
            name="ImportantDate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("text", models.CharField(max_length=100)),
                ("date", models.DateField(db_index=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AlterField(
            model_name="document",
            name="locale",
            field=kitsune.sumo.models.LocaleField(
                choices=[
                    (b"af", "Afrikaans"),
                    (b"ar", "عربي"),
                    (b"az", "Azərbaycanca"),
                    (b"bg", "Български"),
                    (b"bm", "Bamanankan"),
                    (b"bn-BD", "বাংলা (বাংলাদেশ)"),
                    (b"bn-IN", "বাংলা (ভারত)"),
                    (b"bs", "Bosanski"),
                    (b"ca", "català"),
                    (b"cs", "Čeština"),
                    (b"da", "Dansk"),
                    (b"de", "Deutsch"),
                    (b"ee", "Èʋegbe"),
                    (b"el", "Ελληνικά"),
                    (b"en-US", "English"),
                    (b"es", "Español"),
                    (b"et", "eesti keel"),
                    (b"eu", "Euskara"),
                    (b"fa", "فارسی"),
                    (b"fi", "suomi"),
                    (b"fr", "Français"),
                    (b"fy-NL", "Frysk"),
                    (b"ga-IE", "Gaeilge (Éire)"),
                    (b"gl", "Galego"),
                    (b"gn", "Avañe'ẽ"),
                    (b"gu-IN", "ગુજરાતી"),
                    (b"ha", "هَرْشَن هَوْسَ"),
                    (b"he", "עברית"),
                    (b"hi-IN", "हिन्दी (भारत)"),
                    (b"hr", "Hrvatski"),
                    (b"hu", "Magyar"),
                    (b"dsb", "Dolnoserbšćina"),
                    (b"hsb", "Hornjoserbsce"),
                    (b"id", "Bahasa Indonesia"),
                    (b"ig", "Asụsụ Igbo"),
                    (b"it", "Italiano"),
                    (b"ja", "日本語"),
                    (b"ka", "ქართული"),
                    (b"km", "ខ្មែរ"),
                    (b"kn", "ಕನ್ನಡ"),
                    (b"ko", "한국어"),
                    (b"ln", "Lingála"),
                    (b"lt", "lietuvių kalba"),
                    (b"mg", "Malagasy"),
                    (b"mk", "Македонски"),
                    (b"ml", "മലയാളം"),
                    (b"ms", "Bahasa Melayu"),
                    (b"ne-NP", "नेपाली"),
                    (b"nl", "Nederlands"),
                    (b"no", "Norsk"),
                    (b"pl", "Polski"),
                    (b"pt-BR", "Português (do Brasil)"),
                    (b"pt-PT", "Português (Europeu)"),
                    (b"ro", "română"),
                    (b"ru", "Русский"),
                    (b"si", "සිංහල"),
                    (b"sk", "slovenčina"),
                    (b"sl", "slovenščina"),
                    (b"sq", "Shqip"),
                    (b"sr", "Српски"),
                    (b"sw", "Kiswahili"),
                    (b"sv", "Svenska"),
                    (b"ta", "தமிழ்"),
                    (b"ta-LK", "தமிழ் (இலங்கை)"),
                    (b"te", "తెలుగు"),
                    (b"th", "ไทย"),
                    (b"tn", "Setswana"),
                    (b"tr", "Türkçe"),
                    (b"uk", "Українська"),
                    (b"ur", "اُردو"),
                    (b"vi", "Tiếng Việt"),
                    (b"wo", "Wolof"),
                    (b"xh", "isiXhosa"),
                    (b"yo", "èdè Yorùbá"),
                    (b"zh-CN", "中文 (简体)"),
                    (b"zh-TW", "正體中文 (繁體)"),
                    (b"zu", "isiZulu"),
                ],
                db_index=True,
                default=b"en-US",
                max_length=7,
            ),
        ),
        migrations.CreateModel(
            name="DocumentLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("kind", models.CharField(max_length=16)),
                (
                    "linked_from",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="documentlink_to_set",
                        to="wiki.document",
                    ),
                ),
                (
                    "linked_to",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="documentlink_from_set",
                        to="wiki.document",
                    ),
                ),
            ],
            options={
                "unique_together": {("linked_from", "linked_to", "kind")},
            },
        ),
        migrations.AlterField(
            model_name="document",
            name="locale",
            field=kitsune.sumo.models.LocaleField(
                choices=[
                    (b"af", "Afrikaans"),
                    (b"ar", "عربي"),
                    (b"az", "Azərbaycanca"),
                    (b"bg", "Български"),
                    (b"bm", "Bamanankan"),
                    (b"bn", "বাংলা"),
                    (b"bs", "Bosanski"),
                    (b"ca", "català"),
                    (b"cs", "Čeština"),
                    (b"da", "Dansk"),
                    (b"de", "Deutsch"),
                    (b"ee", "Èʋegbe"),
                    (b"el", "Ελληνικά"),
                    (b"en-US", "English"),
                    (b"es", "Español"),
                    (b"et", "eesti keel"),
                    (b"eu", "Euskara"),
                    (b"fa", "فارسی"),
                    (b"fi", "suomi"),
                    (b"fr", "Français"),
                    (b"fy-NL", "Frysk"),
                    (b"ga-IE", "Gaeilge (Éire)"),
                    (b"gl", "Galego"),
                    (b"gn", "Avañe'ẽ"),
                    (b"gu-IN", "ગુજરાતી"),
                    (b"ha", "هَرْشَن هَوْسَ"),
                    (b"he", "עברית"),
                    (b"hi-IN", "हिन्दी (भारत)"),
                    (b"hr", "Hrvatski"),
                    (b"hu", "Magyar"),
                    (b"dsb", "Dolnoserbšćina"),
                    (b"hsb", "Hornjoserbsce"),
                    (b"id", "Bahasa Indonesia"),
                    (b"ig", "Asụsụ Igbo"),
                    (b"it", "Italiano"),
                    (b"ja", "日本語"),
                    (b"ka", "ქართული"),
                    (b"km", "ខ្មែរ"),
                    (b"kn", "ಕನ್ನಡ"),
                    (b"ko", "한국어"),
                    (b"ln", "Lingála"),
                    (b"lt", "lietuvių kalba"),
                    (b"mg", "Malagasy"),
                    (b"mk", "Македонски"),
                    (b"ml", "മലയാളം"),
                    (b"ms", "Bahasa Melayu"),
                    (b"ne-NP", "नेपाली"),
                    (b"nl", "Nederlands"),
                    (b"no", "Norsk"),
                    (b"pl", "Polski"),
                    (b"pt-BR", "Português (do Brasil)"),
                    (b"pt-PT", "Português (Europeu)"),
                    (b"ro", "română"),
                    (b"ru", "Русский"),
                    (b"si", "සිංහල"),
                    (b"sk", "slovenčina"),
                    (b"sl", "slovenščina"),
                    (b"sq", "Shqip"),
                    (b"sr", "Српски"),
                    (b"sw", "Kiswahili"),
                    (b"sv", "Svenska"),
                    (b"ta", "தமிழ்"),
                    (b"ta-LK", "தமிழ் (இலங்கை)"),
                    (b"te", "తెలుగు"),
                    (b"th", "ไทย"),
                    (b"tn", "Setswana"),
                    (b"tr", "Türkçe"),
                    (b"uk", "Українська"),
                    (b"ur", "اُردو"),
                    (b"vi", "Tiếng Việt"),
                    (b"wo", "Wolof"),
                    (b"xh", "isiXhosa"),
                    (b"yo", "èdè Yorùbá"),
                    (b"zh-CN", "中文 (简体)"),
                    (b"zh-TW", "正體中文 (繁體)"),
                    (b"zu", "isiZulu"),
                ],
                db_index=True,
                default=b"en-US",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="is_archived",
            field=models.BooleanField(
                db_index=True,
                default=False,
                help_text="If checked, this wiki page will be hidden from basic searches and dashboards. When viewed, the page will warn that it is no longer maintained.",
                verbose_name="is obsolete",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="locale",
            field=kitsune.sumo.models.LocaleField(
                choices=[
                    ("af", "Afrikaans"),
                    ("ar", "عربي"),
                    ("az", "Azərbaycanca"),
                    ("bg", "Български"),
                    ("bm", "Bamanankan"),
                    ("bn", "বাংলা"),
                    ("bs", "Bosanski"),
                    ("ca", "català"),
                    ("cs", "Čeština"),
                    ("da", "Dansk"),
                    ("de", "Deutsch"),
                    ("ee", "Èʋegbe"),
                    ("el", "Ελληνικά"),
                    ("en-US", "English"),
                    ("es", "Español"),
                    ("et", "eesti keel"),
                    ("eu", "Euskara"),
                    ("fa", "فارسی"),
                    ("fi", "suomi"),
                    ("fr", "Français"),
                    ("fy-NL", "Frysk"),
                    ("ga-IE", "Gaeilge (Éire)"),
                    ("gl", "Galego"),
                    ("gn", "Avañe'ẽ"),
                    ("gu-IN", "ગુજરાતી"),
                    ("ha", "هَرْشَن هَوْسَ"),
                    ("he", "עברית"),
                    ("hi-IN", "हिन्दी (भारत)"),
                    ("hr", "Hrvatski"),
                    ("hu", "Magyar"),
                    ("dsb", "Dolnoserbšćina"),
                    ("hsb", "Hornjoserbsce"),
                    ("id", "Bahasa Indonesia"),
                    ("ig", "Asụsụ Igbo"),
                    ("it", "Italiano"),
                    ("ja", "日本語"),
                    ("ka", "ქართული"),
                    ("km", "ខ្មែរ"),
                    ("kn", "ಕನ್ನಡ"),
                    ("ko", "한국어"),
                    ("ln", "Lingála"),
                    ("lt", "lietuvių kalba"),
                    ("mg", "Malagasy"),
                    ("mk", "Македонски"),
                    ("ml", "മലയാളം"),
                    ("ms", "Bahasa Melayu"),
                    ("ne-NP", "नेपाली"),
                    ("nl", "Nederlands"),
                    ("no", "Norsk"),
                    ("pl", "Polski"),
                    ("pt-BR", "Português (do Brasil)"),
                    ("pt-PT", "Português (Europeu)"),
                    ("ro", "română"),
                    ("ru", "Русский"),
                    ("si", "සිංහල"),
                    ("sk", "slovenčina"),
                    ("sl", "slovenščina"),
                    ("sq", "Shqip"),
                    ("sr", "Српски"),
                    ("sw", "Kiswahili"),
                    ("sv", "Svenska"),
                    ("ta", "தமிழ்"),
                    ("ta-LK", "தமிழ் (இலங்கை)"),
                    ("te", "తెలుగు"),
                    ("th", "ไทย"),
                    ("tn", "Setswana"),
                    ("tr", "Türkçe"),
                    ("uk", "Українська"),
                    ("ur", "اُردو"),
                    ("vi", "Tiếng Việt"),
                    ("wo", "Wolof"),
                    ("xh", "isiXhosa"),
                    ("yo", "èdè Yorùbá"),
                    ("zh-CN", "中文 (简体)"),
                    ("zh-TW", "正體中文 (繁體)"),
                    ("zu", "isiZulu"),
                ],
                db_index=True,
                default="en-US",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="share_link",
            field=models.CharField(default="", max_length=24),
        ),
        migrations.CreateModel(
            name="Locale",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        default="en-US",
                        max_length=7,
                        unique=True,
                    ),
                ),
                (
                    "editors",
                    models.ManyToManyField(
                        blank=True, related_name="locales_editor", to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "leaders",
                    models.ManyToManyField(
                        blank=True, related_name="locales_leader", to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "reviewers",
                    models.ManyToManyField(
                        blank=True, related_name="locales_reviewer", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "ordering": ["locale"],
            },
        ),
        migrations.AlterField(
            model_name="document",
            name="related_documents",
            field=models.ManyToManyField(blank=True, to="wiki.document"),
        ),
        migrations.CreateModel(
            name="DraftRevision",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(default=datetime.datetime.now)),
                ("keywords", models.CharField(blank=True, max_length=255)),
                ("content", models.TextField(blank=True)),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        db_index=True,
                        default="en-US",
                        max_length=7,
                    ),
                ),
                ("slug", models.CharField(blank=True, max_length=255)),
                ("summary", models.TextField(blank=True)),
                ("title", models.CharField(blank=True, max_length=255)),
                (
                    "based_on",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="wiki.revision"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_%(class)ss",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="wiki.document",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(kitsune.search.models.SearchMixin, models.Model),
        ),
        migrations.AlterField(
            model_name="revision",
            name="document",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)ss",
                to="wiki.document",
            ),
        ),
    ]
