from django.core.management.base import BaseCommand

from kitsune.tags.models import SumoTaggedItem
from kitsune.wiki.models import Document


class Command(BaseCommand):
    help = "Dumps out a python file with the topic strings."

    def handle(self, *arg, **kwargs):
        print("##########################################################")
        print("### This file is generated by ./manage.py dump_topics. ###")
        print("##########################################################")
        print("from django.utils.translation import pgettext\n")
        for tag in SumoTaggedItem.tags_for(Document):
            print('pgettext("KB Topic", """{tag}""")'.format(tag=tag.name))
