# Generated by Django 4.1.7 on 2023-04-18 15:46

import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import kitsune.search.models
import kitsune.sumo.models
import timezone_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0001_initial"),
        ("wiki", "0001_squashed_0013_alter_document_related_documents_and_more"),
        ("questions", "0001_squashed_0013_alter_question_is_archived"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("products", "0001_squashed_0005_auto_20200629_0826"),
    ]

    operations = [
        migrations.CreateModel(
            name="RegistrationProfile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("activation_key", models.CharField(max_length=40, verbose_name="activation key")),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        unique=True,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "registration profile",
                "verbose_name_plural": "registration profiles",
            },
        ),
        migrations.CreateModel(
            name="Setting",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("value", models.CharField(blank=True, max_length=60, verbose_name="Value")),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="settings",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "unique_together": {("user", "name")},
            },
        ),
        migrations.CreateModel(
            name="EmailChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("activation_key", models.CharField(max_length=40, verbose_name="activation key")),
                ("email", models.EmailField(db_index=True, max_length=254, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        unique=True,
                        verbose_name="user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Deactivation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("date", models.DateTimeField(default=datetime.datetime.now)),
                (
                    "moderator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="deactivations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="moderator",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Profile",
            fields=[
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Display name"
                    ),
                ),
                (
                    "public_email",
                    models.BooleanField(
                        default=False,
                        verbose_name="Make my email address visible to signed in users",
                    ),
                ),
                (
                    "avatar",
                    models.ImageField(
                        blank=True,
                        max_length=250,
                        null=True,
                        upload_to="uploads/avatars/",
                        verbose_name="Avatar",
                    ),
                ),
                (
                    "bio",
                    models.TextField(
                        blank=True,
                        help_text="Some HTML supported: &#x3C;abbr title&#x3E; &#x3C;acronym title&#x3E; &#x3C;b&#x3E; &#x3C;blockquote&#x3E; &#x3C;code&#x3E; &#x3C;em&#x3E; &#x3C;i&#x3E; &#x3C;li&#x3E; &#x3C;ol&#x3E; &#x3C;strong&#x3E; &#x3C;ul&#x3E;. Links are forbidden.",
                        null=True,
                        verbose_name="Biography",
                    ),
                ),
                (
                    "website",
                    models.URLField(blank=True, max_length=255, null=True, verbose_name="Website"),
                ),
                (
                    "twitter",
                    models.CharField(
                        blank=True,
                        max_length=15,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^[\\w]+$",
                                code="Invalid name",
                                message="Please enter correct Twitter Handle",
                            )
                        ],
                        verbose_name="Twitter Username",
                    ),
                ),
                (
                    "timezone",
                    timezone_field.fields.TimeZoneField(
                        blank=True, default="US/Pacific", null=True, verbose_name="Timezone"
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("AF", "Afghanistan"),
                            ("AX", "Åland Islands"),
                            ("AL", "Albania"),
                            ("DZ", "Algeria"),
                            ("AS", "American Samoa"),
                            ("AD", "Andorra"),
                            ("AO", "Angola"),
                            ("AI", "Anguilla"),
                            ("AQ", "Antarctica"),
                            ("AG", "Antigua and Barbuda"),
                            ("AR", "Argentina"),
                            ("AM", "Armenia"),
                            ("AW", "Aruba"),
                            ("AU", "Australia"),
                            ("AT", "Austria"),
                            ("AZ", "Azerbaijan"),
                            ("BS", "Bahamas"),
                            ("BH", "Bahrain"),
                            ("BD", "Bangladesh"),
                            ("BB", "Barbados"),
                            ("BY", "Belarus"),
                            ("BE", "Belgium"),
                            ("BZ", "Belize"),
                            ("BJ", "Benin"),
                            ("BM", "Bermuda"),
                            ("BT", "Bhutan"),
                            ("BO", "Bolivia, Plurinational State of"),
                            ("BA", "Bosnia and Herzegovina"),
                            ("BW", "Botswana"),
                            ("BV", "Bouvet Island"),
                            ("BR", "Brazil"),
                            ("IO", "British Indian Ocean Territory"),
                            ("BN", "Brunei Darussalam"),
                            ("BG", "Bulgaria"),
                            ("BF", "Burkina Faso"),
                            ("BI", "Burundi"),
                            ("KH", "Cambodia"),
                            ("CM", "Cameroon"),
                            ("CA", "Canada"),
                            ("CV", "Cape Verde"),
                            ("KY", "Cayman Islands"),
                            ("CF", "Central African Republic"),
                            ("TD", "Chad"),
                            ("CL", "Chile"),
                            ("CN", "China"),
                            ("CX", "Christmas Island"),
                            ("CC", "Cocos (Keeling) Islands"),
                            ("CO", "Colombia"),
                            ("KM", "Comoros"),
                            ("CG", "Congo"),
                            ("CD", "Congo, The Democratic Republic of the"),
                            ("CK", "Cook Islands"),
                            ("CR", "Costa Rica"),
                            ("CI", "Côte d'Ivoire"),
                            ("HR", "Croatia"),
                            ("CU", "Cuba"),
                            ("CY", "Cyprus"),
                            ("CZ", "Czech Republic"),
                            ("DK", "Denmark"),
                            ("DJ", "Djibouti"),
                            ("DM", "Dominica"),
                            ("DO", "Dominican Republic"),
                            ("EC", "Ecuador"),
                            ("EG", "Egypt"),
                            ("SV", "El Salvador"),
                            ("GQ", "Equatorial Guinea"),
                            ("ER", "Eritrea"),
                            ("EE", "Estonia"),
                            ("ET", "Ethiopia"),
                            ("FK", "Falkland Islands (Malvinas)"),
                            ("FO", "Faroe Islands"),
                            ("FJ", "Fiji"),
                            ("FI", "Finland"),
                            ("FR", "France"),
                            ("GF", "French Guiana"),
                            ("PF", "French Polynesia"),
                            ("TF", "French Southern Territories"),
                            ("GA", "Gabon"),
                            ("GM", "Gambia"),
                            ("GE", "Georgia"),
                            ("DE", "Germany"),
                            ("GH", "Ghana"),
                            ("GI", "Gibraltar"),
                            ("GR", "Greece"),
                            ("GL", "Greenland"),
                            ("GD", "Grenada"),
                            ("GP", "Guadeloupe"),
                            ("GU", "Guam"),
                            ("GT", "Guatemala"),
                            ("GG", "Guernsey"),
                            ("GN", "Guinea"),
                            ("GW", "Guinea-Bissau"),
                            ("GY", "Guyana"),
                            ("HT", "Haiti"),
                            ("HM", "Heard Island and McDonald Islands"),
                            ("VA", "Holy See (Vatican City State)"),
                            ("HN", "Honduras"),
                            ("HK", "Hong Kong"),
                            ("HU", "Hungary"),
                            ("IS", "Iceland"),
                            ("IN", "India"),
                            ("ID", "Indonesia"),
                            ("IR", "Iran, Islamic Republic of"),
                            ("IQ", "Iraq"),
                            ("IE", "Ireland"),
                            ("IM", "Isle of Man"),
                            ("IL", "Israel"),
                            ("IT", "Italy"),
                            ("JM", "Jamaica"),
                            ("JP", "Japan"),
                            ("JE", "Jersey"),
                            ("JO", "Jordan"),
                            ("KZ", "Kazakhstan"),
                            ("KE", "Kenya"),
                            ("KI", "Kiribati"),
                            ("KP", "Korea, Democratic People's Republic of"),
                            ("KR", "Korea, Republic of"),
                            ("KW", "Kuwait"),
                            ("KG", "Kyrgyzstan"),
                            ("LA", "Lao People's Democratic Republic"),
                            ("LV", "Latvia"),
                            ("LB", "Lebanon"),
                            ("LS", "Lesotho"),
                            ("LR", "Liberia"),
                            ("LY", "Libyan Arab Jamahiriya"),
                            ("LI", "Liechtenstein"),
                            ("LT", "Lithuania"),
                            ("LU", "Luxembourg"),
                            ("MO", "Macao"),
                            ("MK", "Macedonia, The Former Yugoslav Republic of"),
                            ("MG", "Madagascar"),
                            ("MW", "Malawi"),
                            ("MY", "Malaysia"),
                            ("MV", "Maldives"),
                            ("ML", "Mali"),
                            ("MT", "Malta"),
                            ("MH", "Marshall Islands"),
                            ("MQ", "Martinique"),
                            ("MR", "Mauritania"),
                            ("MU", "Mauritius"),
                            ("YT", "Mayotte"),
                            ("MX", "Mexico"),
                            ("FM", "Micronesia, Federated States of"),
                            ("MD", "Moldova, Republic of"),
                            ("MC", "Monaco"),
                            ("MN", "Mongolia"),
                            ("ME", "Montenegro"),
                            ("MS", "Montserrat"),
                            ("MA", "Morocco"),
                            ("MZ", "Mozambique"),
                            ("MM", "Myanmar"),
                            ("NA", "Namibia"),
                            ("NR", "Nauru"),
                            ("NP", "Nepal"),
                            ("NL", "Netherlands"),
                            ("AN", "Netherlands Antilles"),
                            ("NC", "New Caledonia"),
                            ("NZ", "New Zealand"),
                            ("NI", "Nicaragua"),
                            ("NE", "Niger"),
                            ("NG", "Nigeria"),
                            ("NU", "Niue"),
                            ("NF", "Norfolk Island"),
                            ("MP", "Northern Mariana Islands"),
                            ("NO", "Norway"),
                            ("OM", "Oman"),
                            ("PK", "Pakistan"),
                            ("PW", "Palau"),
                            ("PS", "Palestinian Territory, Occupied"),
                            ("PA", "Panama"),
                            ("PG", "Papua New Guinea"),
                            ("PY", "Paraguay"),
                            ("PE", "Peru"),
                            ("PH", "Philippines"),
                            ("PN", "Pitcairn"),
                            ("PL", "Poland"),
                            ("PT", "Portugal"),
                            ("PR", "Puerto Rico"),
                            ("QA", "Qatar"),
                            ("RE", "Réunion"),
                            ("RO", "Romania"),
                            ("RU", "Russian Federation"),
                            ("RW", "Rwanda"),
                            ("BL", "Saint Barthélemy"),
                            ("SH", "Saint Helena, Ascension and Tristan Da Cunha"),
                            ("KN", "Saint Kitts and Nevis"),
                            ("LC", "Saint Lucia"),
                            ("MF", "Saint Martin"),
                            ("PM", "Saint Pierre and Miquelon"),
                            ("VC", "Saint Vincent and the Grenadines"),
                            ("WS", "Samoa"),
                            ("SM", "San Marino"),
                            ("ST", "Sao Tome and Principe"),
                            ("SA", "Saudi Arabia"),
                            ("SN", "Senegal"),
                            ("RS", "Serbia"),
                            ("SC", "Seychelles"),
                            ("SL", "Sierra Leone"),
                            ("SG", "Singapore"),
                            ("SK", "Slovakia"),
                            ("SI", "Slovenia"),
                            ("SB", "Solomon Islands"),
                            ("SO", "Somalia"),
                            ("ZA", "South Africa"),
                            ("GS", "South Georgia and the South Sandwich Islands"),
                            ("ES", "Spain"),
                            ("LK", "Sri Lanka"),
                            ("SD", "Sudan"),
                            ("SR", "Suriname"),
                            ("SJ", "Svalbard and Jan Mayen"),
                            ("SZ", "Swaziland"),
                            ("SE", "Sweden"),
                            ("CH", "Switzerland"),
                            ("SY", "Syrian Arab Republic"),
                            ("TW", "Taiwan"),
                            ("TJ", "Tajikistan"),
                            ("TZ", "Tanzania, United Republic of"),
                            ("TH", "Thailand"),
                            ("TL", "Timor-Leste"),
                            ("TG", "Togo"),
                            ("TK", "Tokelau"),
                            ("TO", "Tonga"),
                            ("TT", "Trinidad and Tobago"),
                            ("TN", "Tunisia"),
                            ("TR", "Turkey"),
                            ("TM", "Turkmenistan"),
                            ("TC", "Turks and Caicos Islands"),
                            ("TV", "Tuvalu"),
                            ("UG", "Uganda"),
                            ("UA", "Ukraine"),
                            ("AE", "United Arab Emirates"),
                            ("GB", "United Kingdom"),
                            ("US", "United States"),
                            ("UM", "United States Minor Outlying Islands"),
                            ("UY", "Uruguay"),
                            ("UZ", "Uzbekistan"),
                            ("VU", "Vanuatu"),
                            ("VE", "Venezuela, Bolivarian Republic of"),
                            ("VN", "Viet Nam"),
                            ("VG", "Virgin Islands, British"),
                            ("VI", "Virgin Islands, U.S."),
                            ("WF", "Wallis and Futuna"),
                            ("EH", "Western Sahara"),
                            ("YE", "Yemen"),
                            ("ZM", "Zambia"),
                            ("ZW", "Zimbabwe"),
                        ],
                        max_length=2,
                        null=True,
                        verbose_name="Country",
                    ),
                ),
                (
                    "city",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="City"),
                ),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        default="en-US",
                        max_length=7,
                        verbose_name="Preferred language",
                    ),
                ),
                (
                    "first_answer_email_sent",
                    models.BooleanField(
                        default=False, help_text="Has been sent a first answer contribution email."
                    ),
                ),
                (
                    "first_l10n_email_sent",
                    models.BooleanField(
                        default=False,
                        help_text="Has been sent a first revision contribution email.",
                    ),
                ),
                (
                    "involved_from",
                    models.DateField(
                        blank=True, null=True, verbose_name="Involved with Mozilla from"
                    ),
                ),
                (
                    "csat_email_sent",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When the user was sent a community health survey",
                    ),
                ),
                ("fxa_uid", models.CharField(blank=True, max_length=128, null=True, unique=True)),
                ("is_fxa_migrated", models.BooleanField(default=False)),
                ("fxa_avatar", models.URLField(blank=True, default="", max_length=512)),
                (
                    "products",
                    models.ManyToManyField(related_name="subscribed_users", to="products.product"),
                ),
                ("fxa_password_change", models.DateTimeField(blank=True, null=True)),
                (
                    "community_mozilla_org",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=255,
                        verbose_name="Community Portal Username",
                    ),
                ),
                (
                    "matrix_handle",
                    models.CharField(
                        blank=True, default="", max_length=255, verbose_name="Matrix Nickname"
                    ),
                ),
                (
                    "people_mozilla_org",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=255,
                        verbose_name="People Directory Username",
                    ),
                ),
                ("fxa_refresh_token", models.CharField(blank=True, default="", max_length=128)),
                ("zendesk_id", models.CharField(blank=True, default="", max_length=1024)),
            ],
            options={
                "permissions": (
                    ("view_karma_points", "Can view karma points"),
                    ("deactivate_users", "Can deactivate users"),
                ),
            },
            bases=(models.Model, kitsune.search.models.SearchMixin),
        ),
        migrations.CreateModel(
            name="AccountEvent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "unprocessed"),
                            (2, "processed"),
                            (3, "ignored"),
                            (4, "not-implemented"),
                        ],
                        default=1,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("last_modified", models.DateTimeField(auto_now=True)),
                ("body", models.TextField(max_length=4096)),
                ("event_type", models.CharField(blank=True, default="", max_length=256)),
                ("fxa_uid", models.CharField(blank=True, default="", max_length=128)),
                ("jwt_id", models.CharField(max_length=256)),
                ("issued_at", models.CharField(max_length=32)),
                (
                    "profile",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="account_events",
                        to="users.profile",
                    ),
                ),
            ],
            options={
                "ordering": ["-last_modified"],
            },
        ),
    ]
