# Generated by Django 4.2.16 on 2024-11-15 02:41

from django.db import migrations

ZENDESK_TAGS = [
    ("Churn", "seg-churn"),
    ("Gecko", "seg-gecko"),
    ("Review prompt", "seg-review-prompt"),
    ("Tablet UI", "seg-tablet-ui"),
    ("iPad", "seg-ipad"),
    ("Gestures", "seg-gestures"),
    ("Youtube buffering", "seg-youtube-buffering"),
    ("new tab behavior feature", "seg-new-tab-behavior-feat"),
    ("Tabs:reload-bug", "seg-tabs-reload-bug"),
    ("PDF:disable-PDF-viewer-feat", "seg-disable-pdf-viewer-feat"),
    ("PDF:save-as-pdf", "seg-save-as-pdf"),
    ("Memory issue", "seg-memory-issue"),
    ("Battery drain", "seg-battery-drain"),
    ("Parental settings", "seg-parental-settings"),
    ("Sponsored content", "seg-sponsored-content"),
    ("DoH", "seg-doh"),
    ("Private Browsing", "seg-private-browsing"),
    ("Reader Mode", "seg-reader-mode"),
    ("Bookmark:organization", "seg-organization"),
    ("Bookmarks:import/export-feat", "seg-import-export-feature"),
    ("Shortcuts", "seg-shortcuts"),
    ("Custom-url-as-homepage", "seg-custom-url-as-homepage"),
    ("Download-manager-feat", "seg-download-manager-feat"),
    ("Adblock", "seg-adblock"),
    ("Tab:group-feat", "seg-tab-group-feat"),
    ("Data-collection-concern", "seg-data-collection-concern"),
    ("Wont-load", "seg-wont-load"),
    ("no-need-to-reply", "seg-not-actionable"),
    ("Browser collections", "seg-browser-collections"),
    ("About:config", "seg-about-config"),
    ("Swipe gesture", "seg-swipe-gesture"),
    ("Open last tab", "seg-ios-open-last-tab"),
    ("Optimization app size", "seg-optimization-app-size"),
    ("Rendering issue", "seg-rendering-issue"),
    ("Scrolling", "seg-scrolling"),
    ("No secure connection", "seg-no-secure-connection"),
    ("Desktop mode", "seg-breakage-desktop-mode"),
    ("Android Translate", "seg-android-translate"),
    ("iOS Translate", "seg-ios-translate"),
    ("Compliment", "seg-compliment"),
    ("Competitior", "seg-competitor"),
    ("UI-UIX", "seg-ui-ux"),
    ("Updated review", "seg-updated-review"),
    ("Not Firefox", "seg-not-firefox"),
    ("cancel_no", "seg-cancel-no"),
    ("cancel_yes", "seg-cancel-yes"),
    ("Cancel no reason", "seg-cancel-no-reason"),
    ("Didnt want Renewal-Forgot to cancel", "seg-cancel-forgot"),
    ("Doesnt fit customer's needs/Missing Features", "seg-cancel-disappointed"),
    ("Duplicate subscription", "seg-cancel-duplicate"),
    ("Forgot Coupon", "seg-cancel-forgot-coupon"),
    ("Personal Reasons", "seg-cancel-personal"),
    ("Remaining subscription from upgrade", "seg-cancel-upgrade-leftover"),
    ("Unauthorized Purchase", "seg-cancel-unauthorized"),
    ("Wrong Plan-Account", "seg-cancel-wrong-plan-acct"),
    ("credit_no", "seg-credit-no"),
    ("credit_yes", "seg-credit-yes"),
    ("refund_no", "seg-refund-no"),
    ("refund_yes", "seg-refund-yes"),
    ("refund-courtesy", "seg-refund-courtesy"),
    ("refund-dispute", "seg-refund-dispute"),
    ("refund-duplicate", "seg-refund-duplicate"),
    ("refund-trial", "seg-refund-trial"),
    ("Apple mail", "seg-apple-mail"),
    ("Google/Gmail", "seg-google-gmail"),
    ("MS mail", "seg-ms-mail"),
    ("Proton mail", "seg-proton-mail"),
    ("Yahoo", "seg-yahoo"),
    ("Other mail domain", "seg-other-mail-domain"),
    ("googleplay", "seg-googleplay"),
    ("ios", "seg-ios"),
    ("linux", "seg-linux"),
    ("linux-debian", "seg-linux-debian"),
    ("linux-fedora", "seg-linux-fedora"),
    ("mac", "seg-mac"),
    ("win10", "seg-win10"),
    ("win11", "seg-win11"),
    ("firefox_accounts", "seg-firefox-accounts"),
    ("mozilla-vpn", "seg-mozilla-vpn"),
    ("hubs", "seg-hubs"),
    ("mdn-plus", "seg-mdn-plus"),
    ("monitor", "seg-monitor"),
    ("mozilla-account", "seg-mozilla-account"),
    ("pocket", "seg-pocket"),
    ("relay", "seg-relay"),
    ("feature-request", "seg-feature-request"),
    ("customer-education/user-confusion", "seg-customer-education-user-confusion"),
    ("feedback", "seg-feedback"),
    ("Troubleshooting", "seg-troubleshooting"),
    ("qa/test-Ticket", "seg-qa-test-ticket"),
    ("sunset-questions", "seg-sunset-questions"),
    ("bug-performance-issue", "seg-bug-performance-issue"),
    ("ux-ui-feedback", "seg-ux-ui-feedback"),
    ("incident", "seg-incident"),
    ("spam", "seg-spam"),
    ("non-descript-inquiry", "seg-non-descript-inquiry"),
    ("undefined-issue-No taxonomy", "seg-undefined-issue-no-taxonomy"),
    ("other-mozilla-product/MOFO", "seg-other-mozilla-product-mofo"),
    ("3rdparty-redirect", "seg-3rd-party-redirect"),
    (
        "Accounts::Switched-Lost device-No recovery codes",
        "seg-acct-switched-lost-device-no-rec-codes",
    ),
    ("Accounts::Codes not working-Accepted", "seg-acct-codes-not-working"),
    ("Accounts::Lost Backup/Recovery-Emergency Code", "seg-acct-lost-backup-code"),
    ("Accounts:Not receiving email verification code", "seg-acct-not-receiving-verification-code"),
    ("Accounts::No longer have access to primary email", "seg-acct-lost-access-to-primary-email"),
    ("Accounts::Change Email", "seg-acct-change-email"),
    ("Accounts::Enable-Disable 2FA", "seg-acct-enable-disable-2fa"),
    ("Accounts::Password reset data loss concerns", "seg-acct-data-loss-concern"),
    ("Accounts::Password not being accepted", "seg-acct-pw-not-accepted"),
    ("Accounts::Add/Remove 3rd party auth", "seg-acct-addremove-3rd-pty-auth"),
    ("Accounts::Hacked Account", "seg-acct-hacked-acct"),
    ("Accounts::Compliance::Account Deletion", "seg-acct-delete"),
    ("Accounts::Compliance::Data Access", "seg-acct-data-access"),
    ("Accounts::Compliance::Unsubscribe Request", "seg-acct-unsubscribe"),
    ("Billing::Declined payment::CVV Fail", "seg-bill-cvv"),
    ("Billing::Declined payment::Bank Declined", "seg-bill-declined"),
    ("Billing::Declined payment::Too Many Tries", "seg-bill-too-many-attempts"),
    ("Billing::Billing Inquiry::Purchase Questions", "seg-bill-purchase-question"),
    ("Billing::Billing Inquiry::Invoice Request", "seg-bill-invoice"),
    ("Billing::Billing Inquiry::Sales Tax Inquiry", "seg-bill-tax-inquiry"),
    ("Billing::Billing Inquiry::Sales tax shouldn't be charged", "seg-bill-no-tax"),
    ("Billing::Billing Inquiry::Wrong Sales Tax amount", "seg-bill-wrong-tax"),
    ("Billing::Upgrade/downgrade subscription::Upgrade Subscription", "seg-bill-upgrade"),
    ("Billing::Upgrade/downgrade subscription::Downgrade Subscription", "seg-bill-downgrade"),
    ("Billing::Billing Inquiry::Unsupported Territory", "seg-bill-unsupported-territory"),
    ("Billing::Billing Inquiry::Update Payment Information", "seg-bill-update-payment-info"),
    ("Monitor::Inaccurate scan results", "seg-mntor-wrong-scan-result"),
    ("Monitor::Slow removal", "seg-mntor-slow-remove"),
    ("Monitor::Broker still showing data", "seg-mntor-data-visible-broker"),
    ("Monitor::Added wrong info", "seg-mntor-add-wrong-info"),
    ("Pocket::Unable to save content", "seg-pk-no-save"),
    ("Pocket:: Third party content issues", "seg-pk-3rd-pty-content"),
    ("Pocket::Creating-Managing Collections", "seg-pk-collections"),
    ("Pocket::Unsupported content types", "seg-pk-unsup-content"),
    ("Pocket::Viewing and Sorting Content", "seg-pk-view-sort"),
    ("Pocket::Exporting content", "seg-pk-export"),
    ("Pocket::Extension Issue", "seg-pk-extension"),
    ("Pocket::Mobile App Issues", "seg-pk-mobile-app"),
    ("Pocket::Deleted content recovery", "seg-pk-delete-content-rec"),
    ("Pocket::Unable to delete content", "seg-pk-no-delete"),
    ("Relay::Calls not forwarded", "seg-relay-call-no-fwd"),
    ("Relay:Change Domain", "seg-relay-chg-domain"),
    ("Relay::Change Phone number", "seg-relay-chg-number"),
    ("Relay::Delay receiving forwarded email", "seg-relay-delay-fwd"),
    ("Relay::Deleted-Missing Mask", "seg-relay-missing-mask"),
    ("Relay::Attachment Limit", "seg-relay-attach-limit"),
    ("Relay::bounced forwarded email", "seg-relay-bounced-fwd-email"),
    ("Relay::Forwards not delivered", "seg-relay-no-fwd-deliver"),
    ("Relay::Icon Blocking input field", "seg-relay-icon-block"),
    ("Relay::Missing labels", "seg-relay-label-missing"),
    ("Relay::Paused Account", "seg-relay-pause-acct"),
    ("Relay::Phone-Text limits not reset", "seg-relay-phone-no-limit-reset"),
    ("Relay::Replies not being sent", "seg-relay-no-reply-sent"),
    ("Relay::Site not accepting mask", "seg-relay-no-mask-accept"),
    ("Relay::Spammed Mask Disabled", "seg-relay-spam-mask"),
    ("Relay::Unable to create domain", "seg-relay-no-create-domain"),
    ("Relay::Unable to create mask", "seg-relay-no-create-mask"),
    ("Relay::Unable to register phone number", "seg-relay-no-reg-phone"),
    ("Relay::Unauthorized mask created", "seg-relay-unauth-mask"),
    ("VPN::Add device", "seg-vpn-add-device"),
    ("VPN::Remove device", "seg-vpn-remove-device"),
    ("VPN::Blocked::Application", "seg-vpn-block-app"),
    ("VPN::Blocked::Service", "seg-vpn-block-svc"),
    ("VPN::Blocked::Website", "seg-vpn-block-site"),
    ("VPN::Can't print on VPN", "seg-cant-print-on-vpn"),
    ("VPN::Sever Unavailable", "seg-vpn-server-unavail"),
    ("VPN::Background Service Error", "seg-vpn-bckgrd-svc-err"),
    ("VPN::No Signal", "seg-vpn-no-signal"),
    ("VPN::Wont Connect", "seg-vpn-wont-connect"),
    ("VPN::Unsupported::iOS", "seg-vpn-unsup-ios"),
    ("VPN::Unsupported::Linux", "seg-vpn-unsup-linux"),
    ("VPN::Unsupported::Mac OS", "seg-vpn-unsup-mac"),
    ("VPN::Unsupported::No OS Named", "seg-vpn-unsup-none"),
    ("VPN::Unsupported::Hardware", "seg-vpn-unsup-hrdware"),
    ("VPN::Unsupported::Windows", "seg-vpn-unsup-win"),
]


def migrate_and_create_tags(apps, schema_editor):
    Tag = apps.get_model("taggit", "Tag")
    TaggedItem = apps.get_model("taggit", "TaggedItem")
    SumoTag = apps.get_model("tags", "SumoTag")
    SumoTaggedItem = apps.get_model("tags", "SumoTaggedItem")

    tag_mapping = {}
    for tag in Tag.objects.all():
        sumo_tag, _ = SumoTag.objects.get_or_create(
            name=tag.name,
            slug=tag.slug,
        )
        tag_mapping[tag.id] = sumo_tag.id

    for tagged_item in TaggedItem.objects.all():
        sumo_tag_id = tag_mapping.get(tagged_item.tag_id)
        if sumo_tag_id:
            SumoTaggedItem.objects.create(
                tag_id=sumo_tag_id,
                content_type=tagged_item.content_type,
                object_id=tagged_item.object_id,
            )

    for tag_name, tag_slug in ZENDESK_TAGS:
        SumoTag.objects.get_or_create(name=tag_name, defaults={"slug": tag_slug})


def reverse_migration(apps, schema_editor):
    SumoTag = apps.get_model("tags", "SumoTag")
    SumoTaggedItem = apps.get_model("tags", "SumoTaggedItem")
    SumoTaggedItem.objects.all().delete()
    SumoTag.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ("tags", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(migrate_and_create_tags, reverse_migration),
    ]
