import { Graph } from "sumo/js/rickshaw_utils";

/*
* Scripts to support Graphs on wiki article history.
*/

(function ($) {
  function init() {
    $('#show-graph').off('click');
    $('#show-graph').html(gettext('Loading...'));
    $('#show-graph').css('color', '#333333').css('cursor', 'auto').css('text-decoration', 'none');
    initGraph();
  }

  function initGraph() {
    $.ajax({
      type: 'GET',
      url: $('#helpful-graph').data('url'),
      success: function (data) {
        if (data.datums.length > 0) {
          rickshawGraph(data);
          $('#show-graph').hide();
        } else {
          $('#show-graph').html(gettext('No votes data'));
          $('#show-graph').off('click');
        }
      },
      error: function () {
        $('#show-graph').html(gettext('Error loading graph'));
        $('#show-graph').off('click');
      }
    });
  }

  function rickshawGraph(data) {
    var $container = $('#helpful-graph');
    var sets = {};

    sets[gettext('Votes')] = ['yes', 'no'];
    sets[gettext('Percent')] = ['percent'];

    data.seriesSpec = [
      {
        name: gettext('Yes'),
        slug: 'yes',
        func: Graph.identity('yes'),
        color: '#21de2b',
        axisGroup: 'votes'
      },
      {
        name: gettext('No'),
        slug: 'no',
        func: Graph.identity('no'),
        color: '#de2b21',
        axisGroup: 'votes'
      },
      {
        name: gettext('Percent'),
        slug: 'percent',
        func: Graph.percentage('yes', 'no'),
        color: '#2b21de',
        axisGroup: 'percent',
        type: 'percent'
      }
    ];

    $container.show();
    var graph = new Graph($container, {
      data: data,
      graph: {
        width: 600
      },
      options: {
        bucket: true,
        legend: false,
        sets: true,
        timeline: true
      },
      metadata: {
        sets: sets
      }
    });

    graph.render();
  }

  $('#show-graph').on("click", init);
})(jQuery);
