# Generated by Django 4.2.16 on 2024-11-05 05:32
from django.db import migrations


def remove_orphaned_and_archived_tags(apps, schema_editor):
    Tag = apps.get_model("taggit", "Tag")
    TaggedItem = apps.get_model("taggit", "TaggedItem")
    Question = apps.get_model("questions", "Question")
    ContentType = apps.get_model("contenttypes", "ContentType")

    orphaned_tags = Tag.objects.filter(taggit_taggeditem_items__isnull=True)
    orphaned_tags.delete()

    question_content_type = ContentType.objects.get_for_model(Question)
    archived_tag_ids = TaggedItem.objects.filter(
        content_type=question_content_type,
        object_id__in=Question.objects.filter(is_archived=True).values_list("id", flat=True),
    ).values_list("tag_id", flat=True)

    non_archived_tag_ids = TaggedItem.objects.filter(
        content_type=question_content_type,
        object_id__in=Question.objects.filter(is_archived=False).values_list("id", flat=True),
    ).values_list("tag_id", flat=True)

    exclusively_archived_tag_ids = set(archived_tag_ids) - set(non_archived_tag_ids)
    exclusively_archived_tags = Tag.objects.filter(id__in=exclusively_archived_tag_ids)
    exclusively_archived_tags.delete()


def backwards(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("questions", "0017_question_update_topic_counter"),
    ]

    operations = [migrations.RunPython(remove_orphaned_and_archived_tags, backwards)]
