# Generated by Django 4.2.14 on 2024-08-02 05:24

from django.db import migrations
from django.db.models import Count


def migrate_question_locales(apps, schema_editor):
    AAQConfig = apps.get_model("questions", "AAQConfig")
    QuestionLocale = apps.get_model("questions", "QuestionLocale")

    for question_locale in QuestionLocale.objects.all():
        for product in question_locale.products.all():
            if not product.is_archived:
                title = f"{product.title} Configuration"
                aaq_config, created = AAQConfig.objects.get_or_create(
                    product=product, defaults={"title": title}
                )
                if not created:
                    aaq_config.title = title
                    aaq_config.is_active = False
                aaq_config.enabled_locales.add(question_locale)

            match product.slug:
                case "firefox":
                    aaq_config.extra_fields = ["troubleshooting", "ff_version", "os"]
                case "mobile":
                    aaq_config.extra_fields = ["ff_version", "os"]
                case "ios":
                    aaq_config.extra_fields = ["ff_version", "os"]
                case "firefox-enterprise":
                    aaq_config.extra_fields = ["ff_version", "os"]
                case "focus-firefox":
                    aaq_config.extra_fields = ["ff_version", "os"]
                case _:
                    pass
            aaq_config.save()

    # Best effort to enable by default configurations
    annotated_configs = (
        AAQConfig.objects.filter(product__is_archived=False)
        .values("product")
        .annotate(config_count=Count("product"))
    )
    unique_products = annotated_configs.filter(config_count=1)
    AAQConfig.objects.filter(product__in=[i["product"] for i in unique_products]).update(
        is_active=True
    )


def backwards(apps, schema_editor): ...


class Migration(migrations.Migration):

    dependencies = [
        ("questions", "0014_aaqconfig_associated_tags_aaqconfig_enabled_locales_and_more"),
    ]

    operations = [migrations.RunPython(migrate_question_locales, backwards)]
