# Generated by Django 4.2.21 on 2025-05-20 14:23

from django.db import migrations


def update_topic_title(apps, schema_editor):
    Topic = apps.get_model("products", "Topic")

    try:
        topic = Topic.objects.get(
            title="Cookies",
            is_archived=False,
            parent__title="Tracking protection",
            parent__is_archived=False,
            parent__parent__title="Privacy and security",
            parent__parent__is_archived=False,
            parent__parent__parent__isnull=True,
        )
    except Topic.DoesNotExist:
        print('The topic "Privacy and security > Tracking protection > Cookies" does not exist.')
    except Topic.MultipleObjectsReturned:
        print(
            'Multiple instances of the topic "Privacy and security > Tracking protection'
            ' > Cookies" exist.'
        )
    else:
        topic.title = "Cookies as trackers"
        topic.save()
        print(
            'Successfully updated the title of the topic "Privacy and security > Tracking'
            ' protection > Cookies" to "Cookies as trackers".'
        )


class Migration(migrations.Migration):

    dependencies = [
        ("products", "0023_initial_topic_metadata"),
    ]

    operations = [
        migrations.RunPython(update_topic_title, migrations.RunPython.noop),
    ]
