# Generated by Django 4.2.21 on 2025-05-13 15:04

from django.db import migrations

TOPICS_WITH_METADATA = [
    {
        "title": "Accessibility",
        "metadata": {
            "description": (
                "Content, questions, or issues related to accessibility features and"
                " settings. This might include screen reader compatibility, ability to"
                " navigate sites via keyboard shortcuts, voice-to-text compatibility,"
                " color combinations with a contrast ratio intended for increased"
                " legibility, etc."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Reader View",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to our Reader Mode feature."
                    ),
                    "examples": [
                        (
                            "On some pages, reader view shows the wrong text -- it"
                            " looks like it picks up text from a hyperlink.  An example"
                            " is the page"
                            " https://www.britannica.com/biography/Pee-Wee-Russell"
                            " where Reader View shows the text from"
                            " https://www.britannica.com/art/clarinet (which is linked"
                            " inside). I am using Firefox 134.0 on MacOS (Sequoia 15.2)"
                        ),
                        (
                            "The reader view is an amazing tool that helps declutter"
                            " websites and make them easier to read. However, this"
                            " experience is ruined by having a super bright white"
                            " background that to my knowledge I can't make black. I"
                            " tried the setting that disables overriding the colors but"
                            " it still remains white. Any ideas why that happens and"
                            " how to change it?"
                        ),
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "Text-to-speech",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to Text-to-speech"
                        " accessibility tools."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Listen",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the Listen"
                                " functionality of Text-to-speech accessibility tools."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
        ],
    },
    {
        "title": "Accounts",
        "metadata": {
            "description": (
                "Content, questions, or issues related to managing accounts and"
                " profiles (e.g. - including Mozilla Accounts and Firefox profiles)."
            ),
            "examples": [
                (
                    "I received an email stating there was activity on my"
                    " account, but it showed it from an unknown location.  I've"
                    " since reset my password and enabled MFA.  I need to know"
                    " if someone actually got into my account and accessed my"
                    " data.  I tried to log out of the session from the Unknown"
                    " location, but it wouldn't respond to the command."
                ),
                (
                    "Hi my phone was stolen and they have managed to unlock it,"
                    " gain access, and configure it so that I cannot remotely erase"
                    " it. Is there a way of logging out of my Firefox account on"
                    " the stolen phone?"
                ),
            ],
        },
        "subtopics": [
            {
                "title": "Account management",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing account"
                        " settings and preferences."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Edit account details",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to updating"
                                " account details."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Location",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Account"
                                " location or location services."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Account recovery",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to recovering a user's account."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Profiles",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to creating and managing"
                        " settings for user profiles."
                    ),
                    "examples": [
                        "I just tried creating a new profile in Nightly, and I"
                        ' received the "Approve sign-in to Firefox" email with a'
                        " code, twice, but the profile page kept saying that my"
                        " email bounced or something. Now it's saying it's locked."
                    ],
                },
                "subtopics": [],
            },
        ],
    },
    {
        "title": "Backup, recovery, and sync",
        "metadata": {
            "description": (
                "Content, questions, or issues related to syncing data between Firefox"
                " browsers across platforms and devices, backing up personal data, and"
                " recovery methods if a user loses data."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Backup data",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to how users can back up"
                        " data, like passwords and bookmarks, with backup tools and"
                        " functionality."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Recover data",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to recovering lost data"
                        " like bookmarks, saved tabs, settings, or account data."
                    ),
                    "examples": [
                        (
                            "All of a sudden, all my bookmarks are gone. I read the"
                            ' instructions on using the "Restore" function to find a'
                            " backup.  I am on a Mac, and I found all the backups of my"
                            " bookmarks in Finder. BUT, when I go through the Restore"
                            ' function and click "Choose File" nothing happens -- I am'
                            " not given any way to navigate to a location and select a"
                            " file.  HELP!!!  I use my bookmarks daily in my job!"
                        ),
                        (
                            "Hi, I recently purchased a new laptop and want to bring"
                            " over the bookmarks I had from my old laptop. I had copied"
                            " what I thought was the profile from the old one and"
                            " copied it into the new laptop - but I'm not sure of the"
                            " next steps :(."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Sync and backup confusion",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to users who"
                                " expect the Firefox Sync tool to work as a backup."
                                " This could apply to users who are generally confused"
                                " about the difference between syncing and backing up"
                                " data, but we mostly see this in the context of"
                                " Firefox Sync."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Sync data",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to syncing data between"
                        " Firefox browsers across platforms and devices. This topic can"
                        " apply to data like passwords, browser sessions, tabs,"
                        " bookmarks, add-ons, and settings."
                    ),
                    "examples": [
                        (
                            "Firefox is installed on my desktop and on my cell. How"
                            " can I get my cell to show all bookmarks that I have on my"
                            " desktop?"
                        ),
                        (
                            "I am trying to save my bookmarks from my mobile firefox"
                            " account to my desktop version."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Sync configuration",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to managing data"
                                " sync settings or configuring Firefox Sync across"
                                " devices."
                            ),
                            "examples": [
                                "Settings does not have the Sync choice on my Samsung Galaxy 24."
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Sync failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to data sync not"
                                " functioning properly across devices (either with"
                                " Firefox Sync or another product's sync"
                                " functionality)."
                            ),
                            "examples": [
                                (
                                    "I'm signed into my account yet locally I'm not"
                                    " getting data to sync across devices. Any idea?"
                                ),
                                (
                                    "Hello Mozilla. I am logged on to my Firefox"
                                    " account on a new computer. Although I have logged"
                                    " in, I haven't experienced Firefox automatically"
                                    " syncing my bookmarks and extensions as I did two"
                                    " computers ago to this last computer. I have tried"
                                    " syncing numerous time (pressing the sync button"
                                    " in my account) to no avail. What do I need to do"
                                    " to get this working?"
                                ),
                                (
                                    "When I tapped sync on my Mac's Firefox, the"
                                    " Android device is not even shown. I can see my"
                                    " Windows Firefox there and see open tabs from"
                                    " there but not from Android. Why doesn't"
                                    " Android Firefox sync?"
                                ),
                                (
                                    "I reinstalled Firefox on my android phone and"
                                    " I am not able to sync the phone now with my"
                                    " account info and bookmarks. Scanning the barcode"
                                    " to sync from my phone does not work. It does not"
                                    " respond at all. Manually entering my email and"
                                    " password does not work either as it says I have"
                                    " the incorrect password when inputting the code"
                                    " sent by email."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Billing and subscriptions",
        "metadata": {
            "description": (
                "Content, questions, or issues related to signing up, settings, and"
                " managing billing for Mozilla product subscriptions."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Manage billing",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing billing for"
                        " product subscriptions (i.e. - adding or removing payment"
                        " cards, changing billing addresses, etc.)."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Billing inquiry",
                        "metadata": {
                            "description": (
                                "General questions or issues related to billing for"
                                " product subscriptions such as billing cadences,"
                                " taxes, or payment methods."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Declined payment",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to payments or"
                                " forms of payment that are declined."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Sales tax",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to how sales tax"
                                " is applied to Mozilla's product subscriptions."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Manage subscriptions",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing"
                        " subscriptions to one or more of Mozilla's premium products,"
                        " such as subscription bundling, how to cancel or change"
                        " subscription tiers, and more."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Cancellation",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to cancelling a"
                                " subscription to one or more of Mozilla's premium"
                                " products."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Upgrade/downgrade subscription",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to upgrading or"
                                " downgrading a subscription to a different tier of"
                                " service."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Browse",
        "metadata": {
            "description": (
                "Content, questions, or issues related to browsing the web with Firefox."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Article View",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to Pocket's Article View feature."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Customized reader",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to customizing"
                                " Pocket's reader feature."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Audio and Video",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to audio/video features"
                        " and functionality (i.e. -  PiP, video players, music"
                        " streaming, etc.) in Mozilla products, including any related"
                        " settings."
                    ),
                    "examples": [
                        (
                            "Suddenly, I can't get any sound on netflix, youtube or any"
                            " videos played on Firefox.  My Digital Rights Management"
                            " (DRM) Content is checked on..."
                        ),
                        (
                            "Hi. There is a problem with video playback when skipping"
                            " through the video using a playback bar. The video (but"
                            " not audio) freezes at the spot when one skippes to"
                            " another part of the video and re-establishes after a"
                            " while (not so short while) to the part of the video that"
                            " is currently played. I'm using Linux Fedora."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "PiP",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the"
                                " Picture-in-Picture feature within Firefox, including"
                                " any related settings like enabling PiP video"
                                " controls."
                            ),
                            "examples": ["Does Firefox support picture within picture?"],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Bookmarks",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing saved"
                        " bookmarks and/or the bookmarks toolbar in Firefox."
                    ),
                    "examples": [
                        (
                            "In Safari I can right click on a URL & navigate through a"
                            " hierarchy of folders to a specific location & add the"
                            " bookmark to that folder. Having imported that folder"
                            " hierarchy to Firefox, I can't find a way to save the"
                            " page I am currently on to a particular folder in that"
                            " hierarchy."
                        ),
                        (
                            "Hi, My bookmarks in Firefox Android are not sorted"
                            " as they are with my Firefox Linux and Firefox Windows."
                            " The problem started about 4 to 8 weeks ago. What"
                            " needs to happen to have Firefox Android sort my bookmarks"
                            " the same way as my Firefox Linux and Firefox Windows?"
                        ),
                        (
                            "Initially the bookmarks on Android started appearing in"
                            " apparently random order after every quit/restart. I"
                            " signed out of Laptop and Android, then signed in again"
                            " and set up syncing again on both, but now the bookmarks"
                            " on my Laptop no longer appear on Android at all, even"
                            " after syncing."
                        ),
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "History",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing, navigating,"
                        " or removing browsing history, including any related settings"
                        " like whether or not to remember browser history, clearing"
                        " browser history, etc."
                    ),
                    "examples": [
                        (
                            "I don't fully remember when this happened, but lately the"
                            " browser has trouble clearing my search history even"
                            " though I had it set so that it does so every time I close"
                            " it. I only managed to fix it by making it so that it"
                            " doesn't remember the search history, but some of the old"
                            " searches are still there whenever I punch in part of what"
                            " I was searching."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Cookies",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues about cookies/cache as"
                                " they relate to the browser history, including any"
                                " related settings like whether or not to delete"
                                " cookies when closing the browser, etc."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Home screen",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to navigating and"
                        " customizing the default screen of an app (i.e. - Homepage or"
                        " New Tab in Firefox), including any related settings."
                    ),
                    "examples": [
                        (
                            "How do I set my home page with my yahoo mail account?  I"
                            " looked under your help section and followed instructions"
                            " and it didn't work.  I am currently setting up my new"
                            " computer."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Dashboard",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to dashboards as"
                                " they appear in Mozilla's products, including any"
                                " related settings. For example, the dashboard on the"
                                " homepage of Firefox that displays a user's shortcuts,"
                                " recently visited tabs, bookmarks and collections."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "New tab",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Firefox New"
                                " Tab and any related settings like what is displayed"
                                " in a new tab, etc."
                            ),
                            "examples": [
                                "I used to have an image (dark, stormy sky) in my new"
                                " tabs, that appeared as a background to my grid of"
                                " websites (8 columns x 4 rows). Suddenly, I haven't"
                                " seen it today - just noticed that it's just black."
                                " Can't seem to find where to access the different"
                                " images. Would like the path to find it, or learn if"
                                " it's no longer available or if I can make my own."
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Images and documents",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to saving, managing,"
                        " interacting with document or images with Mozilla's products."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Images",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to image files"
                                " (i.e. - how to download and save images, how they are"
                                " displayed in app, etc.)"
                            ),
                            "examples": [
                                "Some icons and images all over some websites are being"
                                " displayed wrong. I've tried refresh and"
                                " reinstallation without success. I'm running on"
                                " Windows 11."
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "PDFs",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to PDF files"
                                " (i.e. - how to download and save PDFs, how to open"
                                " PDF files, and any PDF-related functionality)."
                            ),
                            "examples": [
                                (
                                    "Whenever I open up PDFs within the Firefox"
                                    " browser, they have a black background and the"
                                    " text and images do not appear. I can copy the"
                                    " text and images out of the pdf and into a word"
                                    " document and it works out fine. Also opening it"
                                    " up on other applications works out fine. Attached"
                                    " is what happens when I open up a known working"
                                    " PDF in Firefox. The browser version is the"
                                    " current version, 135.0."
                                ),
                                (
                                    "Whenever I try to open a PDF, the background is"
                                    " all black. (see image)"
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Links",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to using web links/URL"
                        " functionality and navigation."
                    ),
                    "examples": [
                        (
                            "I need to copy and paste text that's also a link, but"
                            " Firefox isn't letting me highlight it. I can do it in"
                            " Chrome, Brave, & Opera."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Recommendations",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Pocket's"
                                " article recommendations."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Tabs",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing browser"
                        " tabs, including any related settings like tab layout"
                        " (horizontal or vertical), whether to open links in tabs"
                        " rather than windows, whether to ask before quitting tabs,"
                        " etc."
                    ),
                    "examples": [
                        (
                            "I have the most recent update and have been excited about"
                            " tab groups, but it's still not working on mine. I thought"
                            " the update would be available to all as of May 6, 2025."
                            " Is this happening to anyone else?"
                        ),
                        (
                            "I recently decided to try vertical tabs in Firefox, and"
                            " can't find a way to search these tabs as I could when"
                            " they were horizonal, with the downward pointing"
                            " arrowhead. If this is a feature, please let me know how"
                            " to add it to my sidebar, and if not, it would be great if"
                            " this feature could be developed. Thanks!"
                        ),
                        (
                            "Are tab groups like containers i.e. isolated from the"
                            " others, so that I can access sites logged into different"
                            " accounts for instance or separate browsing"
                            " experience/cookies?"
                        ),
                        (
                            "Tonight I noticed that I have new windows created for each"
                            " tab in my firefox window, how can this be turned off?"
                        ),
                    ],
                },
                "subtopics": [],
            },
        ],
    },
    {
        "title": "Download and save",
        "metadata": {
            "description": (
                "Content, questions, or issues related to managing downloaded files and"
                " saving content, including any related related settings like what"
                " folder to save downloaded files to, and whether to always ask where"
                " to save files to."
            ),
            "examples": [
                "Firefox 135.0 (64-bit) on Ubuntu 22.04.5. When trying to save any"
                " file (download, save image etc.) nothing happens. Tried to refresh,"
                " switch off all extensions, clear download history, but nothing"
                " helped. Chrome works on the same machine like a charm. Do you have"
                " any suggestions?"
            ],
        },
        "subtopics": [
            {
                "title": "Downloads",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to managing how"
                        " downloaded files are handled and where they're saved,"
                        " including any related settings."
                    ),
                    "examples": [
                        (
                            "When accessing Outlook (https://outlook.office.com) using"
                            " Firefox ESR version 128.9.0 and attempting to download a"
                            " file attached to an email, the string 'UTF-8' is"
                            " automatically inserted at the beginning of the file name,"
                            " which is causing issues. This phenomenon does not occur"
                            " with other browsers such as Edge or Chrome. Is"
                            " there a way to solve this problem?"
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Download failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to files failing"
                                " to download a file in an app or product."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Print",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to printing"
                                " (i.e. - the in-browser Print function, printing"
                                " images, documents, or emails, etc.)"
                            ),
                            "examples": [
                                (
                                    "Hello, After Firefox removed about:config"
                                    " option from Beta and Night, can you tell me how"
                                    " to remove Header and Footer when I print"
                                    " documents. I don't want to include URL, dates,"
                                    " times etc. but a clean document or file?"
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Save content",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to saving content like"
                        " articles, images, etc."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Highlighting",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the highlight"
                                " function in Pocket."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Missing items",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to saved"
                                " articles going missing in Pocket."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Permanent library",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the Permanent"
                                " Library premium feature in Pocket."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Reading list",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to saving"
                                " webpages or articles to read later using Firefox or"
                                " Pocket's Reading List feature."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Email and messaging",
        "metadata": {
            "description": (
                "Content, questions, or issues related to emails, email providers and"
                " services, and instant messaging."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Attachments",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to file attachments to"
                        " sent or received emails."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Calendar",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to the built in calendar"
                        " functionality in Thunderbird."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Events",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to creating and"
                                " saving events in the Calendar in Thunderbird."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Contacts",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to saving and managing"
                        " contacts in email and messaging."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Import and export email",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to importing and"
                        " exporting email messages between devices or platforms."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Instant messaging",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to instant messaging"
                        " features or services."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Junk email and spam",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to junk email and spam email."
                    ),
                    "examples": [
                        "Please advise if there is a fault with trash folder not being"
                        " emptied every time on closing Thunderbird."
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "Send and receive email",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to sending or receiving"
                        " email (i.e. - scheduling emails, filtering recipients, or"
                        " blocking senders)"
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Email forwarding",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to managing how"
                                " Relay forwards messages from an email mask to a"
                                " user's real email."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
        ],
    },
    {
        "title": "Installation and updates",
        "metadata": {
            "description": (
                "Content, questions, or issues related to installing and updating"
                " Mozilla's products."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Install",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to installing Mozilla's products."
                    ),
                    "examples": [
                        "Do you have an MSI installer available for Windows ARM64?",
                    ],
                },
                "subtopics": [
                    {
                        "title": "ESR",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to installing"
                                " and maintaining the Extended Support Release for"
                                " Firefox (older versions of the browser that are"
                                " maintained and supported for a specific period of"
                                " time)."
                            ),
                            "examples": [
                                (
                                    "I have Firefox 115.0.3 on my Win 7 32bit.  Do I"
                                    " still have to download the ESR or is 115.0.3"
                                    " still in the okay range of 115?"
                                ),
                                (
                                    'I am running Windows 11, with Firefox 97.0 ("Up To'
                                    ' Date"), but the installer for the new 115 ESR'
                                    " does not work. The installer (Firefox"
                                    " Setup 115.18.0.esr.exe) seems to think that my"
                                    " system is running Windows 7 and does not proceed."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Install failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to successful"
                                " app installation."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Update",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to updating Mozilla's"
                        " products for the latest features and improvements."
                    ),
                    "examples": [
                        (
                            "I try to update Firefox once a month, but every 6 hours I"
                            " am notified about the release of a new version, so I have"
                            " to click Cancel. Is it possible to increase this interval"
                            " (at least to 24 hours) or disable it altogether?"
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Update failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to trying to"
                                " update a Mozilla product's app."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
        ],
    },
    {
        "title": "Passwords and sign in",
        "metadata": {
            "description": (
                "Content, questions, or issues related to managing passwords and"
                " signing in to accounts."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Primary password",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to the Primary Password"
                        " used to secure a user's saved usernames and passwords."
                    ),
                    "examples": [
                        (
                            'According to Firefox Help, "After you have defined and set'
                            " your Primary Password, you will be prompted to enter it"
                            " once for each Firefox session, when Firefox needs access"
                            ' to your stored passwords."  But since updating to version'
                            " 136.0 I get asked for my Primary Password even to see my"
                            " home page. Why is this?"
                        ),
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "Reset passwords",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to resetting passwords"
                        " (e.g. - a Mozilla Account password) to regain login access."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Save passwords",
                "metadata": {
                    "description": "Content, questions, or issues related to saving passwords.",
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Password autofill",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to saving"
                                " usernames and passwords, or automatic input of"
                                " usernames and passwords into sign in fields using the"
                                " autofill feature. Note that this topic is unrelated"
                                " to Mozilla passwords."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Password manager",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the Password"
                                " Manager feature."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Sign in",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to signing into"
                        " Mozilla's products, accounts, or services."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "3rd party sign in",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to 3rd party"
                                " authentication methods like signing in with a Google"
                                " or Apple account."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Email verify lockout",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to being unable"
                                " to verify their account due to being locked out of"
                                " their email."
                            ),
                            "examples": [
                                (
                                    "I enter my account name and password and it says"
                                    " this to me \"Sorry. We've locked your account."
                                    " The confirmation email we sent to"
                                    " zlobi_termiantor123@abv.bg was returned and we've"
                                    " locked your account to protect your Firefox"
                                    " data.\" I've been trying to get it back for two"
                                    " months now and I can't. I hope you'll help me."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Sign in failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to users being"
                                " unable to sign in to their account."
                            ),
                            "examples": [
                                (
                                    "I need to sign in so that I can sync my profile"
                                    " but am getting this error message when trying to"
                                    ' reset the password "Primary account email'
                                    " required for reset\". I'm not sure what this"
                                    " means."
                                ),
                                (
                                    "I'm trying to setup a new laptop and when I try to"
                                    " log in I enter my password, I get my email with"
                                    " my 2 factor code, enter it and then it kicks me"
                                    ' back to the password screen saying "Incorrect'
                                    " password\". I've reset the password a few times"
                                    " and still get the same behavior. Am I only"
                                    " allowed to have 1 device logged in at once? I"
                                    " know in the past I was able to have multiple"
                                    " computers logged in."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Two-factor authentication",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to two-factor or"
                        " multi-factor authentication as an extra layer of security"
                        " when signing in."
                    ),
                    "examples": [
                        (
                            "Does Firefox automatically send extra backup"
                            " authentication codes for 2FA once I use up the"
                            " current lot it sent? If not, what do I do for extra"
                            " extra backup authentication codes?"
                        ),
                        (
                            "So basically, I'm trying to add a 2FA code. I"
                            " scanned the code using Google Authenticator, but"
                            " when I try to put in the code, Firefox only lets"
                            " me put 5 digits but not 6. Any solutions?"
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "SMS Recovery",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to users getting"
                                " locked out of their account during the process of"
                                " two-factor authentication."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
        ],
    },
    {
        "title": "Performance and connectivity",
        "metadata": {
            "description": (
                "Content, questions, or issues related to error messages, crashing"
                " applications, connectivity issues, and slow performance (i.e. - when"
                " a Mozilla app does not connect to the internet but other apps do,"
                " when sites crash for no discernable reason, etc.)"
            ),
            "examples": [
                (
                    "I have just installed Firefox on a new iMac, running MacOS"
                    " 15.2. Firefox will not load any of the websites I have"
                    " tried, whereas Safari and Chrome do. I have cleared the"
                    ' History and also set "No proxy" but loading still fails.'
                ),
            ],
        },
        "subtopics": [
            {
                "title": "Connectivity",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to app or product"
                        " connectivity (i.e. - network connectivity, connecting to"
                        " services, etc.)."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Can't select server",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to users being"
                                " unable to select a specific server in Mozilla VPN."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Connection failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to users being"
                                " unable to connect to a sever in Mozilla VPN."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Slow connection",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to slow"
                                " experiences with Mozilla's products or services and"
                                " internet connectivity."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Crashing and slow performance",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to app crashes or"
                        " general slow performance."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "App crash",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to the product"
                                " or app crashing."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "App responsiveness",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to experienced"
                                " slowness and delayed responsiveness with an app or"
                                " product (such as keyboard stuttering, hanging or long"
                                " page loads times, app freezes when opening or"
                                " closing, etc.)"
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Launch failure",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to failures or"
                                " crashes when attempting to launch a product or app."
                            ),
                            "examples": [
                                (
                                    "Can't launch Firefox 3.5.19 on Linux Ubuntu when"
                                    ' trying to run with "./firefox". The terminal'
                                    " gives the following: ./firefox-bin: error while"
                                    " loading shared libraries: libdbus-glib-1.so.2:"
                                    " cannot open shared object file: No such file or"
                                    " directory."
                                ),
                                (
                                    "After Firefox updated today, the executable no"
                                    " longer starts.  I get the following error"
                                    " message: firefox.exe -- Bad Image"
                                    " C:\\Program Files\\Mozilla Firefox\\gkcodecs.dll"
                                    " is either not designed to run on Windows or it"
                                    " contains an error. Error status 0x000000d. And"
                                    " then another error message: Couldn't load XPCOM."
                                    " Please advise."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Loading speed",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to experienced"
                                " slowness when loading websites."
                            ),
                            "examples": [
                                (
                                    "Trying to browse Ebay using Firefox. The pages"
                                    " have become really slow when loading. When"
                                    " scrolling down the page is blank then slowly"
                                    " populates as I scroll down the page.  I've just"
                                    " tried Microsoft Edge and there is no problem."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Error codes",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to encountered error"
                        " codes while trying to navigate a website."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Web certificates",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to expired web"
                                " certificate errors while trying to navigate a"
                                " website."
                            ),
                            "examples": [
                                (
                                    "Hello, I want to open this URL:"
                                    " https://compatibility.plantronics.com/deskphone."
                                    " Firefox 136.0.1 tells me:"
                                    " SEC_ERROR_REVOKED_CERTIFICATE. The same URL opens"
                                    " in Chrome and shows no sign of a security"
                                    " problem, as far as I can see (Chrome info"
                                    " attached). What could be the cause? Firefox being"
                                    " to strict or Chrome just too relaxed?"
                                ),
                            ],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Site breakages",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to whole, or parts of,"
                        " websites not loading or functioning correctly."
                    ),
                    "examples": [
                        (
                            "Suddenly today (April 30) when I try to go to the Youtube"
                            " home page, I get a blank (see the picture). But if I try"
                            " in a private window, it works."
                        ),
                        (
                            "Since the last update (136.0.4 (64bit)) Firefox only"
                            " partially shows an embedded Google spreadsheet. It was"
                            " fine in the previous version. Tried turning off enhanced"
                            " tracking protection, but that didn't do anything."
                        ),
                        (
                            "Hello. I have a problem with Firefox since today. When I"
                            " am on YouTube I no longer see the thumbnail image of the"
                            " video. However, when I am in private browsing it works"
                            " fine. How can I fix this?"
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Blocked application/service/website",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to blocked"
                                " applications, services, or websites that users are"
                                " trying to access."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Security software",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to anti-virus"
                                " software, firewalls, VPNs, and other security"
                                " software affecting the functionality of a website."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Web compatibility",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to sites that"
                                " have been optimized for other browsers but not"
                                " Firefox."
                            ),
                            "examples": [
                                (
                                    "Firefox is not allowing me to login to Reddit.com."
                                    " Nor can I create a new account with Reddit.com"
                                    " with Firefox. I can login fine with Microsoft"
                                    " Edge. I don't want to use Microsoft Edge. I can"
                                    " login fine with Chrome. I don't want to use"
                                    " Chrome. What's Firefox's problem?"
                                ),
                                (
                                    "Two financial websites I normally look at with"
                                    " Firefox suddenly have no images anymore. I think"
                                    " it's the last Firefox update that caused it. Both"
                                    " websites look okay with Chrome."
                                ),
                                (
                                    "Just recently I have found that certain sites are"
                                    " unavailable to me using Firefox but I can access"
                                    " them using Edge or Chrome. One particular one is"
                                    " Squarespace. Is this a known problem? How should"
                                    " I tackle this?"
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Privacy and security",
        "metadata": {
            "description": (
                "Content, questions, or issues related to the privacy and security of"
                " user data in Mozilla's products (i.e. - how Mozilla collects, stores,"
                " and uses user data, as well as how to delete user data)."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Data removal",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to removing personal"
                        " data that has been exposed or is displayed in non-secure"
                        " locations online."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Data brokers",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to data brokers"
                                " - individuals or companies that specialize in"
                                " collecting, buying, and/or selling personal data"
                                " online."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Privacy scan",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Monitor's"
                                " privacy scan feature that allows users to determine"
                                " if their personal information has been exposed"
                                " online."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Encryption",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to  various encryption"
                        " features like HTTPS, ECH, and TLS."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Masking",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to features and"
                        " functionality that allow a user to hide their actual email or"
                        " phone number when using them for online goods and services."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Email and phone masking",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Relay masks"
                                " used to hide a user's actual email."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Email masking",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Relay masks"
                                " used to hide a user's actual phone number."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Phone masking",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to bundled"
                                " features in Relay that hide a user's email and phone"
                                " masking (together instead of separately)."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Security",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to a user's personal"
                        " data security, browser security, etc."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Browser security",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to strategies"
                                " for browsing securely, browser security settings,"
                                " Firefox's innate privacy prioritization, and more."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Device permissions",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to app"
                                " permissions that grant access to parts of a user's"
                                " device, such as the camera, microphone, and more."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Tracking protection",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to enabling tracking"
                        " protection or managing tracking protection settings."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Cookies",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to tracking"
                                " concerns around browser cookies."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Email trackers",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to trackers"
                                " hidden in links, images, or attachments contained in"
                                " the body of the emails that advertisers and third"
                                " parties use to collect information about users via"
                                " marketing emails."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Search, tag, and share",
        "metadata": {
            "description": (
                "Content, questions, or issues related to search functionality and how"
                " to organize (tagging) or share content."
            ),
            "examples": [],
        },
        "subtopics": [
            {
                "title": "Search",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to conducting searches"
                        " in browser, searching for content or settings within a"
                        " product, and general search functionality."
                    ),
                    "examples": [
                        (
                            "Hi, I'm currently on Firefox Developer Edition"
                            " version 136.0b6, and for some reason the search bar no"
                            " longer displays the https:// header. Is it possible to"
                            " turn this back on?"
                        ),
                        (
                            "I have downloaded Mozilla Firefox to my iPad. I keep"
                            " seeing DuckDuckGo as my browser.  I want to change my"
                            " search engine to Firefox but I don't see Firefox as"
                            " a listed search engine that I can choose from.  Does"
                            " Mozilla have its own search engine?  I don't want to"
                            " use the other listed choices such as Google or Bing."
                        ),
                    ],
                },
                "subtopics": [
                    {
                        "title": "Full text search",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to Pocket's"
                                " premium search feature that gives users expanded"
                                " search functionality, such as searching the entire"
                                " text of an article, searching tags, topics, authors,"
                                " and more."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Search suggestions",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to suggested"
                                " search terms offered by the browser when conducting a"
                                " search. This topic can also apply specifically to the"
                                " Firefox Suggest feature."
                            ),
                            "examples": [
                                (
                                    "With search suggestions turned off and browser"
                                    " history completely cleared (all check boxes for"
                                    " all time), Firefox suggests AP News (apnews.com)"
                                    " when I click the search bar. This started kind of"
                                    " recently, though I'm not sure what version"
                                    " triggered the change. I'm not sure how to submit"
                                    " a bug report, so I'm posting here."
                                ),
                                (
                                    "Hi there, Is it possible to add"
                                    " Dictionary.com to the Search bar so words entered"
                                    " there are searched at that site? Previous"
                                    " versions of FF allowed me to map that site to"
                                    " that field. Right now it's doing a Google"
                                    " search for words. Thanks."
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Share content",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to sharing content,"
                        " data, or files like links, articles, or images, especially"
                        " when this is done using the Share functionality."
                    ),
                    "examples": [],
                },
                "subtopics": [],
            },
            {
                "title": "Tags",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to tags or tagging"
                        " functions in products (i.e. - tagging saved articles in"
                        " Pocket, tagging email messages in Thunderbird, or tagging"
                        " masks with labels in Relay)."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Mask labels",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to user-created"
                                " labels for their Relay masks."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Suggested tags",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to content tags"
                                " that are suggested by Pocket."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Settings",
        "metadata": {
            "description": (
                "Content, questions, or issues related to managing and customizing"
                " product settings, add-ons, and more."
            ),
            "examples": [
                (
                    "How do I reset Firefox to open with a single page instead of"
                    " trying to reopen the last pages?"
                ),
            ],
        },
        "subtopics": [
            {
                "title": "Add-ons, extensions, and themes",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to enhancing product"
                        " functionality with add-ons, extensions, and add-on themes."
                        " This does not apply to themes that are built into the"
                        " product, like light or dark mode."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Extensions",
                        "metadata": {
                            "description": (
                                "Content, questions, requests, or issues related to"
                                " product extensions (add-ons)."
                            ),
                            "examples": [
                                (
                                    "When I publish an extension on Chromium-based"
                                    " browsers, I can select the markets/regions in"
                                    " which I would like my extension to be available."
                                    " I cannot find this option in Firefox add-ons. Am"
                                    " I missing something, or should I assume that the"
                                    " add-ons are available for every region in"
                                    " Firefox?"
                                ),
                                (
                                    "I have been using uBlock Origin for years to block"
                                    " ads in YouTube. Recently I started getting ads"
                                    " again and when I checked I found uBlock was"
                                    " disabled and couldn't be enabled. Please help."
                                ),
                                (
                                    "I want to install an extension UBLOCK ORIGIN on"
                                    " Firefox for IOS 18. How do I do this?"
                                ),
                            ],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Themes",
                        "metadata": {
                            "description": (
                                "Content, questions, requests, or issues related to"
                                " add-on themes. This does not apply to themes that are"
                                " built into the product, like light or dark mode."
                            ),
                            "examples": [
                                "Is there a way to add additional themes into Firefox Android?",
                            ],
                        },
                        "subtopics": [],
                    },
                ],
            },
            {
                "title": "Autofill",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to automatically filling"
                        " addresses and payment cards into form fields."
                    ),
                    "examples": [
                        "I have Firefox 136.0.2 (up to date) on Win 11. I want to"
                        " remove specific autofill items, NOT all autofill items. Web"
                        " info says use Settings > Privacy & Security > Forms &"
                        " Autofill, BUT there is nothing for Forms and Autofill in"
                        " my Firefox 136.0.2. Can anyone please help me find how"
                        " to edit autofill in this version?"
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "Customization",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to customizing a"
                        " product's settings and functionality."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Browser appearance",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to customizing"
                                " the Firefox browser's appearance, like customizing"
                                " the default font, showing the sidebar, or selecting"
                                " light or dark mode."
                            ),
                            "examples": [
                                "Don't you have a dark mode? All this brightness hurts my eyes.",
                                (
                                    "As the pic shows, Firefox for Android does a"
                                    " terrible job when showing Chinese characters"
                                    " using its default mono font. It seems that the"
                                    " default mono font doesn't support Chinese. So,"
                                    " what should I do to change the font settings?"
                                ),
                                (
                                    "How do I change weather widget position to left"
                                    " side of Firefox homepage? It was always on the"
                                    " left side and I ran an update this morning and"
                                    " now it is on the right."
                                ),
                                (
                                    "I just upgraded from an older computer OS to"
                                    " Windows 11. I imported my bookmarks but really"
                                    " hate the new look of the bookmarks bar in Win11. "
                                    " The icons are all generic and have no color. "
                                    " I've attached a screen shot illustrating."
                                ),
                                "How can I remove the sidebar?",
                            ],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Import and export settings",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to importing and"
                        " exporting product, account, or profile settings, including"
                        " how to import settings from a non-Firefox browser into a"
                        " Firefox browser."
                    ),
                    "examples": [
                        "I am new to Firefox and tried to import the Google Chrome"
                        " Bookmark Toolbar bookmarks. It did not work. I need to"
                        " get my bookmarks from Chrome into my Firefox browser."
                    ],
                },
                "subtopics": [
                    {
                        "title": "Add device",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to adding a new"
                                " device to a user's account (e.g. - adding a new"
                                " computer to a user's Mozilla VPN account)."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    }
                ],
            },
            {
                "title": "Languages",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to changing and managing"
                        " languages, translations, and locale settings in Mozilla's"
                        " products."
                    ),
                    "examples": [
                        (
                            "The built-in translation feature in the browser is"
                            " a great feature. In the settings I have loaded"
                            " Ukrainian language but when I click on the"
                            " translation button at the end of the address bar"
                            " it is not displayed in the list. Can you please"
                            " tell me what I need to do to display the language"
                            " I need?"
                        ),
                    ],
                },
                "subtopics": [],
            },
            {
                "title": "Notifications",
                "metadata": {
                    "description": (
                        "Content, questions, or issues related to notifications"
                        " received in app, managing notification settings, and more."
                    ),
                    "examples": [],
                },
                "subtopics": [
                    {
                        "title": "Alerts",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to in-product or"
                                " in-app alerts."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Forwarded message notification",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related to notifications"
                                " sent by Relay about messages that have been forwarded"
                                " to a user's real email or phone number."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                    {
                        "title": "Push notifications",
                        "metadata": {
                            "description": (
                                "Content, questions, or issues related specifically to"
                                " notifications pushed to a user's device from a"
                                " Mozilla app."
                            ),
                            "examples": [],
                        },
                        "subtopics": [],
                    },
                ],
            },
        ],
    },
    {
        "title": "Undefined",
        "metadata": {
            "description": "A topic that can be applied to content that is spam or non-actionable",
            "examples": [
                "Please help me!",
                "I've got a problem.",
                "Can you tell me how to create a Gmail account?",
            ],
        },
        "subtopics": [],
    },
]


def add_initial_topic_metadata(apps, schema_editor):
    Topic = apps.get_model("products", "Topic")

    def add_metadata(topics, parent=None):
        for topic_data in topics:
            try:
                topic = Topic.objects.get(
                    title=topic_data["title"], parent=parent, is_archived=False
                )
            except Topic.DoesNotExist:
                print(f"""Skipped topic "{topic_data['title']}" because it does not exist.""")
                continue
            except Topic.MultipleObjectsReturned:
                print(
                    f"""Skipped topic "{topic_data['title']}" because it has multiple objects."""
                )
                continue

            topic.metadata = topic_data["metadata"]
            topic.save()

            add_metadata(topic_data["subtopics"], parent=topic)

    add_metadata(TOPICS_WITH_METADATA)


class Migration(migrations.Migration):

    dependencies = [
        ("products", "0022_topic_metadata"),
    ]

    operations = [
        migrations.RunPython(add_initial_topic_metadata, migrations.RunPython.noop),
    ]
