# Generated by Django 4.1.7 on 2023-04-18 13:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Badge",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        help_text="Short, descriptive title", max_length=255, unique=True
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Very short name, for use in URLs and links", unique=True
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Longer description of the badge and its criteria"
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        blank=True,
                        help_text="Must be square. Recommended 256x256.",
                        null=True,
                        upload_to=b"uploads/badges/",
                    ),
                ),
                (
                    "unique",
                    models.BooleanField(
                        default=True,
                        help_text=b"Should awards of this badge be limited to one-per-person?",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-modified", "-created"],
                "db_table": "badger_badge",
                "unique_together": {("title", "slug")},
            },
        ),
        migrations.CreateModel(
            name="Award",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text=b"Explanation and evidence for the badge award"
                    ),
                ),
                ("image", models.ImageField(blank=True, null=True, upload_to=b"uploads/badges/")),
                ("hidden", models.BooleanField(default=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "badge",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="kbadge.badge"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="award_creator",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="award_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-modified", "-created"],
                "db_table": "badger_award",
            },
        ),
        migrations.RunSQL(
            sql="UPDATE badger_badge SET image = CONCAT('uploads/', image) WHERE image NOT LIKE 'uploads/%' AND image IS NOT NULL AND image != ''",
        ),
        migrations.AlterModelManagers(
            name="award",
            managers=[
                ("admin_objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.AlterField(
            model_name="award",
            name="image",
            field=models.ImageField(blank=True, null=True, upload_to="uploads/badges/"),
        ),
        migrations.AlterField(
            model_name="badge",
            name="image",
            field=models.ImageField(
                blank=True,
                help_text="Must be square. Recommended 256x256.",
                null=True,
                upload_to="uploads/badges/",
            ),
        ),
        migrations.AlterField(
            model_name="badge",
            name="unique",
            field=models.BooleanField(
                default=True, help_text="Should awards of this badge be limited to one-per-person?"
            ),
        ),
        migrations.AlterField(
            model_name="award",
            name="description",
            field=models.TextField(
                blank=True, help_text="Explanation and evidence for the badge award"
            ),
        ),
    ]
