# Generated by Django 4.2.18 on 2025-02-18 11:57

from django.db import migrations


def create_content_team(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Permission = apps.get_model('auth', 'Permission')

    content_team, created = Group.objects.get_or_create(name="Staff Content Team")

    # Define the permissions we want
    permission_codenames = [
        'wiki.archive_document',
        'wiki.change_document',
        'wiki.delete_document',
        'wiki.edit_needs_change',
        'wiki.add_revision',
        'wiki.change_revision',
        'wiki.delete_revision',
        'wiki.edit_keywords',
        'wiki.mark_ready_for_l10n',
        'wiki.review_revision',
    ]

    # Get all the required permissions
    permissions = Permission.objects.filter(
        codename__in=[name.split('.')[-1] for name in permission_codenames],
        content_type__app_label='wiki'
    )

    content_team.permissions.add(*permissions)


def reverse_content_team(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')

    try:
        content_team = Group.objects.get(name="Staff Content Team")
        content_team.permissions.clear()
        content_team.delete()
    except Group.DoesNotExist:
        pass


class Migration(migrations.Migration):

    dependencies = [
        ("groups", "0001_squashed_0002_auto_20200629_0826"),
    ]

    operations = [
        migrations.RunPython(create_content_team, reverse_content_team),
    ]
