# Generated by Django 4.1.7 on 2023-04-18 13:38

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import kitsune.sumo.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Image",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(db_index=True, max_length=255)),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("updated", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("description", models.TextField(max_length=10000)),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        db_index=True,
                        default="en-US",
                        max_length=7,
                    ),
                ),
                ("is_draft", models.BooleanField(default=None, editable=False, null=True)),
                (
                    "file",
                    models.ImageField(
                        height_field="height",
                        max_length=250,
                        upload_to="uploads/gallery/images/",
                        width_field="width",
                    ),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        max_length=250, null=True, upload_to="uploads/gallery/images/thumbnails/"
                    ),
                ),
                ("height", models.IntegerField(null=True)),
                ("width", models.IntegerField(null=True)),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="gallery_images",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
                "abstract": False,
                "unique_together": {("is_draft", "creator"), ("locale", "title")},
            },
        ),
        migrations.CreateModel(
            name="Video",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(db_index=True, max_length=255)),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("updated", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("description", models.TextField(max_length=10000)),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        db_index=True,
                        default="en-US",
                        max_length=7,
                    ),
                ),
                ("is_draft", models.BooleanField(default=None, editable=False, null=True)),
                (
                    "webm",
                    models.FileField(
                        max_length=250, null=True, upload_to="uploads/gallery/videos/"
                    ),
                ),
                (
                    "ogv",
                    models.FileField(
                        max_length=250, null=True, upload_to="uploads/gallery/videos/"
                    ),
                ),
                (
                    "flv",
                    models.FileField(
                        max_length=250, null=True, upload_to="uploads/gallery/videos/"
                    ),
                ),
                (
                    "poster",
                    models.ImageField(
                        max_length=250, null=True, upload_to="uploads/gallery/videos/thumbnails/"
                    ),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        max_length=250, null=True, upload_to="uploads/gallery/videos/thumbnails/"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="gallery_videos",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
                "abstract": False,
                "unique_together": {("is_draft", "creator"), ("locale", "title")},
            },
        ),
    ]
