# Generated by Django 4.1.7 on 2023-04-18 13:31

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import kitsune.search.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("guardian", "0002_generic_permissions_index"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Forum",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("slug", models.SlugField(unique=True)),
                ("description", models.TextField(null=True)),
                ("display_order", models.IntegerField(db_index=True, default=1)),
                ("is_listed", models.BooleanField(db_index=True, default=True)),
            ],
            options={
                "ordering": ["display_order", "id"],
                "permissions": (
                    ("view_in_forum", "Can view restricted forums"),
                    ("post_in_forum", "Can post in restricted forums"),
                ),
            },
        ),
        migrations.CreateModel(
            name="Post",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("content", models.TextField()),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("updated", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "ordering": ["created"],
            },
        ),
        migrations.CreateModel(
            name="Thread",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("replies", models.IntegerField(default=0)),
                ("is_locked", models.BooleanField(default=False)),
                ("is_sticky", models.BooleanField(db_index=True, default=False)),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "forum",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="forums.forum"
                    ),
                ),
                (
                    "last_post",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="last_post_in",
                        to="forums.post",
                    ),
                ),
            ],
            options={
                "ordering": ["-is_sticky", "-last_post__created"],
            },
            bases=(models.Model, kitsune.search.models.SearchMixin),
        ),
        migrations.AddField(
            model_name="post",
            name="thread",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="forums.thread"
            ),
        ),
        migrations.AddField(
            model_name="post",
            name="updated_by",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="post_last_updated_by",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="forum",
            name="last_post",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_post_in_forum",
                to="forums.post",
            ),
        ),
        migrations.AlterModelOptions(
            name="forum",
            options={
                "ordering": ["display_order", "id"],
                "permissions": (
                    ("view_in_forum", "Can view restricted forums"),
                    ("post_in_forum", "Can post in restricted forums"),
                    ("delete_forum_thread", "Can delete forum threads"),
                    ("edit_forum_thread", "Can edit forum threads"),
                    ("lock_forum_thread", "Can lock/unlock forum threads"),
                    ("move_forum_thread", "Can move threads between forums"),
                    ("sticky_forum_thread", "Can mark/unmark a forum thread as sticky"),
                    ("delete_forum_thread_post", "Can delete posts within forum threads"),
                    ("edit_forum_thread_post", "Can edit posts within forum threads"),
                ),
            },
        ),
        migrations.AddField(
            model_name="forum",
            name="restrict_posting",
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AddField(
            model_name="forum",
            name="restrict_viewing",
            field=models.BooleanField(db_index=True, default=False),
        ),
    ]
