# Generated by Django 4.1.7 on 2023-04-18 13:30

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="FlaggedObject",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "Pending"), (1, "Accepted and Fixed"), (2, "Rejected")],
                        db_index=True,
                        default=0,
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("spam", "Spam or other unrelated content"),
                            ("language", "Inappropriate language/dialog"),
                            ("bug_support", "Misplaced bug report or support request"),
                            ("abuse", "Abusive content"),
                            ("other", "Other (please specify)"),
                        ],
                        max_length=64,
                    ),
                ),
                ("notes", models.TextField(blank=True, default="")),
                ("created", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                ("handled", models.DateTimeField(db_index=True, default=datetime.datetime.now)),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="flags",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "handled_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["created"],
                "permissions": (("can_moderate", "Can moderate flagged objects"),),
                "unique_together": {("content_type", "object_id", "creator")},
            },
        ),
    ]
