# Generated by Django 4.1.7 on 2023-04-18 13:29

from django.db import migrations, models
import django.db.models.deletion
import kitsune.sumo.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("products", "0001_squashed_0005_auto_20200629_0826"),
        ("wiki", "0001_squashed_0013_alter_document_related_documents_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="WikiMetric",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        choices=[
                            ("percent_localized_top20", "Percent Localized: Top 20"),
                            ("percent_localized_top100", "Percent Localized: Top 100"),
                            ("percent_localized_all", "Percent Localized: All"),
                            ("active_contributors", "Monthly Active Contributors"),
                        ],
                        db_index=True,
                        max_length=255,
                    ),
                ),
                (
                    "locale",
                    kitsune.sumo.models.LocaleField(
                        blank=True,
                        choices=[
                            ("af", "Afrikaans"),
                            ("ar", "عربي"),
                            ("az", "Azərbaycanca"),
                            ("bg", "Български"),
                            ("bm", "Bamanankan"),
                            ("bn", "বাংলা"),
                            ("bs", "Bosanski"),
                            ("ca", "català"),
                            ("cs", "Čeština"),
                            ("da", "Dansk"),
                            ("de", "Deutsch"),
                            ("ee", "Èʋegbe"),
                            ("el", "Ελληνικά"),
                            ("en-US", "English"),
                            ("es", "Español"),
                            ("et", "eesti keel"),
                            ("eu", "Euskara"),
                            ("fa", "فارسی"),
                            ("fi", "suomi"),
                            ("fr", "Français"),
                            ("fy-NL", "Frysk"),
                            ("ga-IE", "Gaeilge (Éire)"),
                            ("gl", "Galego"),
                            ("gn", "Avañe'ẽ"),
                            ("gu-IN", "ગુજરાતી"),
                            ("ha", "هَرْشَن هَوْسَ"),
                            ("he", "עברית"),
                            ("hi-IN", "हिन्दी (भारत)"),
                            ("hr", "Hrvatski"),
                            ("hu", "Magyar"),
                            ("dsb", "Dolnoserbšćina"),
                            ("hsb", "Hornjoserbsce"),
                            ("id", "Bahasa Indonesia"),
                            ("ig", "Asụsụ Igbo"),
                            ("it", "Italiano"),
                            ("ja", "日本語"),
                            ("ka", "ქართული"),
                            ("km", "ខ្មែរ"),
                            ("kn", "ಕನ್ನಡ"),
                            ("ko", "한국어"),
                            ("ln", "Lingála"),
                            ("lt", "lietuvių kalba"),
                            ("mg", "Malagasy"),
                            ("mk", "Македонски"),
                            ("ml", "മലയാളം"),
                            ("ms", "Bahasa Melayu"),
                            ("ne-NP", "नेपाली"),
                            ("nl", "Nederlands"),
                            ("no", "Norsk"),
                            ("pl", "Polski"),
                            ("pt-BR", "Português (do Brasil)"),
                            ("pt-PT", "Português (Europeu)"),
                            ("ro", "română"),
                            ("ru", "Русский"),
                            ("si", "සිංහල"),
                            ("sk", "slovenčina"),
                            ("sl", "slovenščina"),
                            ("sq", "Shqip"),
                            ("sr", "Српски"),
                            ("sw", "Kiswahili"),
                            ("sv", "Svenska"),
                            ("ta", "தமிழ்"),
                            ("ta-LK", "தமிழ் (இலங்கை)"),
                            ("te", "తెలుగు"),
                            ("th", "ไทย"),
                            ("tn", "Setswana"),
                            ("tr", "Türkçe"),
                            ("uk", "Українська"),
                            ("ur", "اُردو"),
                            ("vi", "Tiếng Việt"),
                            ("wo", "Wolof"),
                            ("xh", "isiXhosa"),
                            ("yo", "èdè Yorùbá"),
                            ("zh-CN", "中文 (简体)"),
                            ("zh-TW", "正體中文 (繁體)"),
                            ("zu", "isiZulu"),
                        ],
                        db_index=True,
                        default="en-US",
                        max_length=7,
                        null=True,
                    ),
                ),
                ("date", models.DateField()),
                ("value", models.FloatField()),
                (
                    "product",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="products.product",
                    ),
                ),
            ],
            options={
                "ordering": ["-date"],
                "unique_together": {("code", "product", "locale", "date")},
            },
        ),
        migrations.CreateModel(
            name="WikiDocumentVisits",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("visits", models.IntegerField(db_index=True)),
                (
                    "period",
                    models.IntegerField(
                        choices=[
                            (0, "Last 7 days"),
                            (2, "Last 30 days"),
                            (3, "Last 90 days"),
                            (1, "Last Year"),
                        ]
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="visits",
                        to="wiki.document",
                    ),
                ),
            ],
            options={
                "unique_together": {("period", "document")},
            },
        ),
    ]
