# Generated by Django 4.1.7 on 2023-04-18 13:23

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wiki", "0001_squashed_0013_alter_document_related_documents_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("auth", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="Announcement",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(default=datetime.datetime.now)),
                (
                    "show_after",
                    models.DateTimeField(
                        db_index=True,
                        default=datetime.datetime.now,
                        help_text="When this announcement will start appearing. (US/Pacific)",
                        verbose_name="Start displaying",
                    ),
                ),
                (
                    "show_until",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        help_text="When this announcement will stop appearing. Leave blank for indefinite. (US/Pacific)",
                        null=True,
                        verbose_name="Stop displaying",
                    ),
                ),
                (
                    "content",
                    models.TextField(
                        help_text="Use wiki syntax or HTML. It will display similar to a document's content.",
                        max_length=10000,
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "locale",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wiki.locale",
                    ),
                ),
                (
                    "send_email",
                    models.BooleanField(
                        default=False,
                        help_text="Send an email to all users in the groups. If no groups are selected, this is ignored.",
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True, null=True, related_name="announcements", to="auth.group"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
