/* ---------------------------------------------------------------------------
 #
 #       L-Py: L-systems in Python
 #
 #       Copyright 2003-2008 UMR Cirad/Inria/Inra Dap - Virtual Plant Team
 #
 #       File author(s): F. Boudon (frederic.boudon@cirad.fr)
 #
 # ---------------------------------------------------------------------------
 #
 #                      GNU General Public Licence
 #
 #       This program is free software; you can redistribute it and/or
 #       modify it under the terms of the GNU General Public License as
 #       published by the Free Software Foundation; either version 2 of
 #       the License, or (at your option) any later version.
 #
 #       This program is distributed in the hope that it will be useful,
 #       but WITHOUT ANY WARRANTY; without even the implied warranty of
 #       MERCHANTABILITY or FITNESS For A PARTICULAR PURPOSE. See the
 #       GNU General Public License for more details.
 #
 #       You should have received a copy of the GNU General Public
 #       License along with this program; see the file COPYING. If not,
 #       write to the Free Software Foundation, Inc., 59
 #       Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 #
 # ---------------------------------------------------------------------------
 */


#include "nodemodule.h"

LPY_USING_NAMESPACE

/*---------------------------------------------------------------------------*/

LPY(NodeModule::NodeModule)(AxialTree::const_iterator pos, 
			 AxialTree::const_iterator beg, 
			 AxialTree::const_iterator end,
             const ConsiderFilterPtr filter):
	ParamModule(*pos), __pos(pos), __beg(beg),__end(end), __filter(filter)
{
}

NodeModule NodeModule::generate(AxialTree::const_iterator pos, 
             AxialTree::const_iterator beg, 
             AxialTree::const_iterator end,
             const ConsiderFilterPtr filter)
{
    return NodeModule(pos, beg, end, filter);
}

NodeModule::~NodeModule() { }

/*
NodeModule::NodeModule() : ParamModule() { }

NodeModule::NodeModule(AxialTree::const_iterator beg, 
             AxialTree::const_iterator end):
    ParamModule(*beg), __pos(beg), __beg(beg),__end(end), __filter()
{
}
*/
/*---------------------------------------------------------------------------*/
