"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.commentTags = exports.commentSummary = exports.comment = void 0;
const utils_1 = require("../../../../utils");
const models_1 = require("../../../../models");
const lib_1 = require("../../lib");
// Note: Comment modifiers are handled in `renderFlags`
function comment({ markdown }, props) {
    if (!props.comment?.hasVisibleComponent())
        return;
    const tags = props.kindOf(models_1.ReflectionKind.SomeSignature)
        ? props.comment.blockTags.filter((tag) => tag.tag !== "@returns")
        : props.comment.blockTags;
    return (utils_1.JSX.createElement("div", { class: "tsd-comment tsd-typography" },
        utils_1.JSX.createElement(utils_1.Raw, { html: markdown(props.comment.summary) }),
        tags.map((item) => (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            utils_1.JSX.createElement("h3", null, (0, lib_1.camelToTitleCase)(item.tag.substring(1))),
            utils_1.JSX.createElement(utils_1.Raw, { html: markdown(item.content) }))))));
}
exports.comment = comment;
function commentSummary({ markdown }, props) {
    if (!props.comment?.summary.some((part) => part.text))
        return;
    return (utils_1.JSX.createElement("div", { class: "tsd-comment tsd-typography" },
        utils_1.JSX.createElement(utils_1.Raw, { html: markdown(props.comment.summary) })));
}
exports.commentSummary = commentSummary;
function commentTags({ markdown }, props) {
    if (!props.comment)
        return;
    const tags = props.kindOf(models_1.ReflectionKind.SomeSignature)
        ? props.comment.blockTags.filter((tag) => tag.tag !== "@returns")
        : props.comment.blockTags;
    return (utils_1.JSX.createElement("div", { class: "tsd-comment tsd-typography" }, tags.map((item) => (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
        utils_1.JSX.createElement("h4", null, (0, lib_1.camelToTitleCase)(item.tag.substring(1))),
        utils_1.JSX.createElement(utils_1.Raw, { html: markdown(item.content) }))))));
}
exports.commentTags = commentTags;
