/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import type { MarkdownConfig } from '@docusaurus/types';
import type { LoaderContext } from 'webpack';
import type { Plugin } from 'unified';
import type { AdmonitionOptions } from './remark/admonitions';
export declare type MDXPlugin = [
    Plugin<any[]>,
    any
] | Plugin<any[]>;
export declare type MDXOptions = {
    admonitions: boolean | AdmonitionOptions;
    remarkPlugins: MDXPlugin[];
    rehypePlugins: MDXPlugin[];
    beforeDefaultRemarkPlugins: MDXPlugin[];
    beforeDefaultRehypePlugins: MDXPlugin[];
};
export declare type Options = Partial<MDXOptions> & {
    markdownConfig: MarkdownConfig;
    staticDirs: string[];
    siteDir: string;
    isMDXPartial?: (filePath: string) => boolean;
    isMDXPartialFrontMatterWarningDisabled?: boolean;
    removeContentTitle?: boolean;
    metadataPath?: string | ((filePath: string) => string);
    createAssets?: (metadata: {
        frontMatter: {
            [key: string]: unknown;
        };
        metadata: {
            [key: string]: unknown;
        };
    }) => {
        [key: string]: unknown;
    };
};
export declare function mdxLoader(this: LoaderContext<Options>, fileString: string): Promise<void>;
//# sourceMappingURL=loader.d.ts.map