"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateOptions = exports.validateThemeConfig = exports.getSwizzleConfig = exports.AnnouncementBarDismissStorageKey = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const module_1 = require("module");
const rtlcss_1 = tslib_1.__importDefault(require("rtlcss"));
const theme_translations_1 = require("@docusaurus/theme-translations");
const translations_1 = require("./translations");
const requireFromDocusaurusCore = (0, module_1.createRequire)(require.resolve('@docusaurus/core/package.json'));
const ContextReplacementPlugin = requireFromDocusaurusCore('webpack/lib/ContextReplacementPlugin');
// Need to be inlined to prevent dark mode FOUC
// Make sure the key is the same as the one in `/theme/hooks/useTheme.js`
const ThemeStorageKey = 'theme';
const ThemeQueryStringKey = 'docusaurus-theme';
const noFlashColorMode = ({ defaultMode, respectPrefersColorScheme, }) => 
/* language=js */
`(function() {
  var defaultMode = '${defaultMode}';
  var respectPrefersColorScheme = ${respectPrefersColorScheme};

  function setDataThemeAttribute(theme) {
    document.documentElement.setAttribute('data-theme', theme);
  }

  function getQueryStringTheme() {
    var theme = null;
    try {
      theme = new URLSearchParams(window.location.search).get('${ThemeQueryStringKey}')
    } catch(e) {}
    return theme;
  }

  function getStoredTheme() {
    var theme = null;
    try {
      theme = localStorage.getItem('${ThemeStorageKey}');
    } catch (err) {}
    return theme;
  }

  var initialTheme = getQueryStringTheme() || getStoredTheme();
  if (initialTheme !== null) {
    setDataThemeAttribute(initialTheme);
  } else {
    if (
      respectPrefersColorScheme &&
      window.matchMedia('(prefers-color-scheme: dark)').matches
    ) {
      setDataThemeAttribute('dark');
    } else if (
      respectPrefersColorScheme &&
      window.matchMedia('(prefers-color-scheme: light)').matches
    ) {
      setDataThemeAttribute('light');
    } else {
      setDataThemeAttribute(defaultMode === 'dark' ? 'dark' : 'light');
    }
  }
})();`;
// Duplicated constant. Unfortunately we can't import it from theme-common, as
// we need to support older nodejs versions without ESM support
// TODO: import from theme-common once we only support Node.js with ESM support
// + move all those announcementBar stuff there too
exports.AnnouncementBarDismissStorageKey = 'docusaurus.announcement.dismiss';
const AnnouncementBarDismissDataAttribute = 'data-announcement-bar-initially-dismissed';
// We always render the announcement bar html on the server, to prevent layout
// shifts on React hydration. The theme can use CSS + the data attribute to hide
// the announcement bar asap (before React hydration)
/* language=js */
const AnnouncementBarInlineJavaScript = `
(function() {
  function isDismissed() {
    try {
      return localStorage.getItem('${exports.AnnouncementBarDismissStorageKey}') === 'true';
    } catch (err) {}
    return false;
  }
  document.documentElement.setAttribute('${AnnouncementBarDismissDataAttribute}', isDismissed());
})();`;
function getInfimaCSSFile(direction) {
    return `infima/dist/css/default/default${direction === 'rtl' ? '-rtl' : ''}.css`;
}
function themeClassic(context, options) {
    const { i18n: { currentLocale, localeConfigs }, } = context;
    const themeConfig = context.siteConfig.themeConfig;
    const { announcementBar, colorMode, prism: { additionalLanguages }, } = themeConfig;
    const { customCss } = options;
    const { direction } = localeConfigs[currentLocale];
    return {
        name: 'docusaurus-theme-classic',
        getThemePath() {
            return '../lib/theme';
        },
        getTypeScriptThemePath() {
            return '../src/theme';
        },
        getTranslationFiles: () => (0, translations_1.getTranslationFiles)({ themeConfig }),
        translateThemeConfig: (params) => (0, translations_1.translateThemeConfig)({
            themeConfig: params.themeConfig,
            translationFiles: params.translationFiles,
        }),
        getDefaultCodeTranslationMessages() {
            return (0, theme_translations_1.readDefaultCodeTranslationMessages)({
                locale: currentLocale,
                name: 'theme-common',
            });
        },
        getClientModules() {
            const modules = [
                require.resolve(getInfimaCSSFile(direction)),
                './prism-include-languages',
                './nprogress',
            ];
            modules.push(...customCss.map((p) => path_1.default.resolve(context.siteDir, p)));
            return modules;
        },
        configureWebpack() {
            const prismLanguages = additionalLanguages
                .map((lang) => `prism-${lang}`)
                .join('|');
            return {
                plugins: [
                    // This allows better optimization by only bundling those components
                    // that the user actually needs, because the modules are dynamically
                    // required and can't be known during compile time.
                    new ContextReplacementPlugin(/prismjs[\\/]components$/, new RegExp(`^./(${prismLanguages})$`)),
                ],
            };
        },
        configurePostCss(postCssOptions) {
            if (direction === 'rtl') {
                const resolvedInfimaFile = require.resolve(getInfimaCSSFile(direction));
                const plugin = {
                    postcssPlugin: 'RtlCssPlugin',
                    prepare: (result) => {
                        const file = result.root.source?.input.file;
                        // Skip Infima as we are using the its RTL version.
                        if (file === resolvedInfimaFile) {
                            return {};
                        }
                        return (0, rtlcss_1.default)(result.root);
                    },
                };
                postCssOptions.plugins.push(plugin);
            }
            return postCssOptions;
        },
        injectHtmlTags() {
            return {
                preBodyTags: [
                    {
                        tagName: 'script',
                        innerHTML: `
${noFlashColorMode(colorMode)}
${announcementBar ? AnnouncementBarInlineJavaScript : ''}
            `,
                    },
                ],
            };
        },
    };
}
exports.default = themeClassic;
var getSwizzleConfig_1 = require("./getSwizzleConfig");
Object.defineProperty(exports, "getSwizzleConfig", { enumerable: true, get: function () { return tslib_1.__importDefault(getSwizzleConfig_1).default; } });
var options_1 = require("./options");
Object.defineProperty(exports, "validateThemeConfig", { enumerable: true, get: function () { return options_1.validateThemeConfig; } });
Object.defineProperty(exports, "validateOptions", { enumerable: true, get: function () { return options_1.validateOptions; } });
