"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSwizzleContext = void 0;
const server_1 = require("../../server");
const init_1 = require("../../server/plugins/init");
const configs_1 = require("../../server/plugins/configs");
async function initSwizzleContext(siteDir, options) {
    const context = await (0, server_1.loadContext)({ siteDir, config: options.config });
    const plugins = await (0, init_1.initPlugins)(context);
    const pluginConfigs = await (0, configs_1.loadPluginConfigs)(context);
    return {
        plugins: plugins.map((plugin, pluginIndex) => ({
            plugin: pluginConfigs[pluginIndex],
            instance: plugin,
        })),
    };
}
exports.initSwizzleContext = initSwizzleContext;
