"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.findClosestValue = exports.findStringIgnoringCase = exports.normalizeOptions = exports.actionStatusSuffix = exports.actionStatusColor = exports.actionStatusLabel = exports.PartiallySafeHint = exports.SwizzleActionsStatuses = exports.SwizzleActions = void 0;
const tslib_1 = require("tslib");
const lodash_1 = tslib_1.__importDefault(require("lodash"));
const logger_1 = tslib_1.__importDefault(require("@docusaurus/logger"));
const leven_1 = tslib_1.__importDefault(require("leven"));
exports.SwizzleActions = ['wrap', 'eject'];
exports.SwizzleActionsStatuses = [
    'safe',
    'unsafe',
    'forbidden',
];
exports.PartiallySafeHint = logger_1.default.red('*');
function actionStatusLabel(status) {
    return lodash_1.default.capitalize(status);
}
exports.actionStatusLabel = actionStatusLabel;
const SwizzleActionStatusColors = {
    safe: logger_1.default.green,
    unsafe: logger_1.default.yellow,
    forbidden: logger_1.default.red,
};
function actionStatusColor(status, str) {
    const colorFn = SwizzleActionStatusColors[status];
    return colorFn(str);
}
exports.actionStatusColor = actionStatusColor;
function actionStatusSuffix(status, options = {}) {
    return ` (${actionStatusColor(status, actionStatusLabel(status))}${options.partiallySafe ? exports.PartiallySafeHint : ''})`;
}
exports.actionStatusSuffix = actionStatusSuffix;
function normalizeOptions(options) {
    return {
        typescript: options.typescript ?? false,
        danger: options.danger ?? false,
        list: options.list ?? false,
        wrap: options.wrap ?? false,
        eject: options.eject ?? false,
        config: options.config ?? undefined,
    };
}
exports.normalizeOptions = normalizeOptions;
function findStringIgnoringCase(str, values) {
    return values.find((v) => v.toLowerCase() === str.toLowerCase());
}
exports.findStringIgnoringCase = findStringIgnoringCase;
function findClosestValue(str, values, maxLevenshtein = 3) {
    return values.find((v) => (0, leven_1.default)(v, str) <= maxLevenshtein);
}
exports.findClosestValue = findClosestValue;
