/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import type { Optional, Required } from 'utility-types';
import type { NumberPrefixParser, SidebarOptions, CategoryIndexMatcher, DocMetadataBase, VersionMetadata } from '@docusaurus/plugin-content-docs';
import type { Slugger } from '@docusaurus/utils';
declare type Expand<T extends {
    [x: string]: unknown;
}> = {
    [P in keyof T]: T[P];
};
export declare type SidebarItemBase = {
    className?: string;
    customProps?: {
        [key: string]: unknown;
    };
};
export declare type SidebarItemDoc = SidebarItemBase & {
    type: 'doc' | 'ref';
    label?: string;
    id: string;
    /**
     * This is an internal marker. Items with labels defined in the config needs
     * to be translated with JSON
     */
    translatable?: true;
};
export declare type SidebarItemHtml = SidebarItemBase & {
    type: 'html';
    value: string;
    defaultStyle?: boolean;
};
export declare type SidebarItemLink = SidebarItemBase & {
    type: 'link';
    href: string;
    label: string;
    autoAddBaseUrl?: boolean;
    description?: string;
};
export declare type SidebarItemAutogenerated = SidebarItemBase & {
    type: 'autogenerated';
    dirName: string;
};
declare type SidebarItemCategoryBase = SidebarItemBase & {
    type: 'category';
    label: string;
    collapsed: boolean;
    collapsible: boolean;
    description?: string;
};
export declare type SidebarItemCategoryLinkDoc = {
    type: 'doc';
    id: string;
};
export declare type SidebarItemCategoryLinkGeneratedIndexConfig = {
    type: 'generated-index';
    slug?: string;
    title?: string;
    description?: string;
    image?: string;
    keywords?: string | readonly string[];
};
export declare type SidebarItemCategoryLinkGeneratedIndex = {
    type: 'generated-index';
    slug: string;
    permalink: string;
    title?: string;
    description?: string;
    image?: string;
    keywords?: string | readonly string[];
};
export declare type SidebarItemCategoryLinkConfig = SidebarItemCategoryLinkDoc | SidebarItemCategoryLinkGeneratedIndexConfig;
export declare type SidebarItemCategoryLink = SidebarItemCategoryLinkDoc | SidebarItemCategoryLinkGeneratedIndex;
export declare type SidebarItemCategoryConfig = Expand<Optional<SidebarItemCategoryBase, 'collapsed' | 'collapsible'> & {
    items: SidebarCategoriesShorthand | SidebarItemConfig[];
    link?: SidebarItemCategoryLinkConfig;
}>;
export declare type SidebarCategoriesShorthand = {
    [sidebarCategory: string]: SidebarCategoriesShorthand | SidebarItemConfig[];
};
export declare type SidebarItemConfig = Omit<SidebarItemDoc, 'translatable'> | SidebarItemHtml | SidebarItemLink | SidebarItemAutogenerated | SidebarItemCategoryConfig | string | SidebarCategoriesShorthand;
export declare type SidebarConfig = SidebarCategoriesShorthand | SidebarItemConfig[];
export declare type SidebarsConfig = {
    [sidebarId: string]: SidebarConfig;
};
export declare type NormalizedSidebarItemCategory = Expand<Optional<SidebarItemCategoryBase, 'collapsed' | 'collapsible'> & {
    items: NormalizedSidebarItem[];
    link?: SidebarItemCategoryLinkConfig;
}>;
export declare type NormalizedSidebarItem = SidebarItemDoc | SidebarItemHtml | SidebarItemLink | NormalizedSidebarItemCategory | SidebarItemAutogenerated;
export declare type NormalizedSidebar = NormalizedSidebarItem[];
export declare type NormalizedSidebars = {
    [sidebarId: string]: NormalizedSidebar;
};
export declare type ProcessedSidebarItemCategory = Expand<Optional<SidebarItemCategoryBase, 'collapsed' | 'collapsible'> & {
    items: ProcessedSidebarItem[];
    link?: SidebarItemCategoryLinkConfig;
}>;
export declare type ProcessedSidebarItem = SidebarItemDoc | SidebarItemHtml | SidebarItemLink | ProcessedSidebarItemCategory;
export declare type ProcessedSidebar = ProcessedSidebarItem[];
export declare type ProcessedSidebars = {
    [sidebarId: string]: ProcessedSidebar;
};
export declare type SidebarItemCategory = Expand<SidebarItemCategoryBase & {
    items: SidebarItem[];
    link?: SidebarItemCategoryLink;
}>;
export declare type SidebarItemCategoryWithLink = Required<SidebarItemCategory, 'link'>;
export declare type SidebarItemCategoryWithGeneratedIndex = SidebarItemCategoryWithLink & {
    link: SidebarItemCategoryLinkGeneratedIndex;
};
export declare type SidebarItem = SidebarItemDoc | SidebarItemHtml | SidebarItemLink | SidebarItemCategory;
export declare type SidebarNavigationItem = SidebarItemDoc | SidebarItemCategoryWithLink;
export declare type Sidebar = SidebarItem[];
export declare type SidebarItemType = SidebarItem['type'];
export declare type Sidebars = {
    [sidebarId: string]: Sidebar;
};
export declare type PropSidebarItemCategory = Expand<SidebarItemCategoryBase & {
    items: PropSidebarItem[];
    href?: string;
}>;
export declare type PropSidebarItemLink = SidebarItemLink & {
    docId?: string;
};
export declare type PropSidebarItemHtml = SidebarItemHtml;
export declare type PropSidebarItem = PropSidebarItemLink | PropSidebarItemCategory | PropSidebarItemHtml;
export declare type PropSidebar = PropSidebarItem[];
export declare type PropSidebars = {
    [sidebarId: string]: PropSidebar;
};
export declare type PropSidebarBreadcrumbsItem = PropSidebarItemLink | PropSidebarItemCategory;
export declare type CategoryMetadataFile = {
    label?: string;
    position?: number;
    collapsed?: boolean;
    collapsible?: boolean;
    className?: string;
    link?: SidebarItemCategoryLinkConfig | null;
    customProps?: {
        [key: string]: unknown;
    };
};
export declare type SidebarItemsGeneratorDoc = Pick<DocMetadataBase, 'id' | 'unversionedId' | 'title' | 'frontMatter' | 'source' | 'sourceDirName' | 'sidebarPosition'>;
export declare type SidebarItemsGeneratorVersion = Pick<VersionMetadata, 'versionName' | 'contentPath'>;
export declare type SidebarItemsGeneratorArgs = {
    /** The sidebar item with type "autogenerated" to be transformed. */
    item: SidebarItemAutogenerated;
    /** Useful metadata for the version this sidebar belongs to. */
    version: SidebarItemsGeneratorVersion;
    /** All the docs of that version (unfiltered). */
    docs: SidebarItemsGeneratorDoc[];
    /** Number prefix parser configured for this plugin. */
    numberPrefixParser: NumberPrefixParser;
    /** The default category index matcher which you can override. */
    isCategoryIndex: CategoryIndexMatcher;
    /**
     * Key is the path relative to the doc content directory, value is the
     * category metadata file's content.
     */
    categoriesMetadata: {
        [filePath: string]: CategoryMetadataFile;
    };
};
export declare type SidebarItemsGenerator = (generatorArgs: SidebarItemsGeneratorArgs) => NormalizedSidebar | Promise<NormalizedSidebar>;
export declare type SidebarItemsGeneratorOption = (generatorArgs: {
    /**
     * Useful to re-use/enhance the default sidebar generation logic from
     * Docusaurus.
     * @see https://github.com/facebook/docusaurus/issues/4640#issuecomment-822292320
     */
    defaultSidebarItemsGenerator: SidebarItemsGenerator;
} & SidebarItemsGeneratorArgs) => NormalizedSidebar | Promise<NormalizedSidebar>;
export declare type SidebarProcessorParams = {
    sidebarItemsGenerator: SidebarItemsGeneratorOption;
    numberPrefixParser: NumberPrefixParser;
    docs: DocMetadataBase[];
    drafts: DocMetadataBase[];
    version: VersionMetadata;
    categoryLabelSlugger: Slugger;
    sidebarOptions: SidebarOptions;
};
export {};
