/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { type ReactNode } from 'react';
/**
 * Split links by left/right. If position is unspecified, fallback to right.
 */
export declare function splitNavbarItems<T extends {
    position?: 'left' | 'right';
}>(items: T[]): [leftItems: T[], rightItems: T[]];
/**
 * Composes multiple navbar state providers that are mutually dependent and
 * hence can't be re-ordered.
 */
export declare function NavbarProvider({ children }: {
    children: ReactNode;
}): JSX.Element;
//# sourceMappingURL=navbarUtils.d.ts.map