"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tempFile = exports.uuid = exports.isSrcKid = exports.replaceEsc = exports.pipelinePromise = exports.setTimeoutPromise = exports.invalidWin32Path = exports.isWindows = exports.umask = void 0;
const path_1 = require("path");
const util_1 = require("util");
const crypto_1 = require("crypto");
const os_1 = require("os");
const stream_1 = require("stream");
exports.umask = process.umask(0o022);
// Fix umask back to original value
process.umask(exports.umask);
exports.isWindows = process.platform === 'win32';
exports.invalidWin32Path = (myPath) => {
    const root = path_1.normalize(path_1.resolve(myPath)).split(path_1.sep);
    return /[<>:"|?*]/.test(myPath.replace(root[0], ''));
};
exports.setTimeoutPromise = util_1.promisify(setTimeout);
exports.pipelinePromise = util_1.promisify(stream_1.pipeline);
exports.replaceEsc = (str) => str.replace(/\$/g, '$$');
exports.isSrcKid = (source, destination) => {
    const sourceArray = path_1.resolve(source).split(path_1.sep);
    const destinationArray = path_1.resolve(destination).split(path_1.sep);
    return sourceArray.every((current, i) => destinationArray[i] === current);
};
exports.uuid = () => {
    const id = crypto_1.randomBytes(32).toString('hex');
    return (Array(32).join('0') + id).slice(-32).replace(/^.{8}|.{4}(?!$)/g, '$&-');
};
exports.tempFile = (ext) => path_1.join(os_1.tmpdir(), exports.uuid() + (ext || ''));
//# sourceMappingURL=util.js.map