"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tar = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const stream_1 = require("stream");
const Header_1 = require("./Header");
class Tar extends stream_1.Readable {
    constructor(base) {
        super();
        this.written = 0;
        this.recordSize = 512;
        this.queue = [];
        this.base = base;
    }
    async _read() {
        if (!this.queue.length) {
            this.push(null);
            return;
        }
        const { header, file, size } = this.queue.shift();
        const { written } = this;
        this.written += header.length;
        const fileChunks = [];
        for await (const chunk of file) {
            fileChunks.push(chunk);
            this.written += chunk.length;
        }
        /* istanbul ignore next: Hard to produce, requires a size perfectibly divisible by the recordSize */
        const extraBytes = this.recordSize - (size % this.recordSize || this.recordSize);
        this.written += extraBytes;
        this.push(Buffer.concat([header, ...fileChunks, Buffer.alloc(extraBytes)], this.written - written));
    }
    append(filepath, stats) {
        this.queue.push({
            header: new Header_1.Header({
                filename: path_1.relative(this.base, filepath),
                mode: stats.mode,
                uid: stats.uid,
                gid: stats.gid,
                size: stats.size,
                mtime: Math.trunc(stats.mtime.valueOf() / 1000),
                type: 0,
                ustar: 'ustar ',
                owner: '',
                group: ''
            }).toBuffer(),
            file: fs_1.createReadStream(filepath),
            size: stats.size
        });
    }
}
exports.Tar = Tar;
//# sourceMappingURL=Tar.js.map