/// <reference types="node" />
export interface HeaderFormat {
    filename?: string;
    mode: number;
    uid: number;
    gid: number;
    size: number;
    mtime: number;
    checksum?: number;
    type?: number;
    linkName?: string;
    ustar?: string;
    owner?: string;
    group?: string;
    majorNumber?: number;
    minorNumber?: number;
    filenamePrefix?: string;
    padding?: any;
}
export declare class Header {
    filename: string;
    mode: number;
    uid: number;
    gid: number;
    size: number;
    mtime: number;
    type: number;
    linkName: string;
    ustar: string;
    owner: string;
    group: string;
    majorNumber: number;
    minorNumber: number;
    filenamePrefix: string;
    constructor(data: HeaderFormat | Buffer);
    get checksum(): number;
    toBuffer(): Buffer;
    private static resolve;
    private static checksum;
    private static readInt;
    private static readString;
    private static pad;
}
