"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeJsonAtomic = exports.writeJSONAtomic = void 0;
const writeJSON_1 = require("./writeJSON");
/**
 * Writes a Javascript Object to file as JSON atomically.
 * @function writeJsonAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param object The javascript object you would like to write to file
 * @param options The options to pass JSON.stringify and writeFile
 */
/**
 * Writes a Javascript Object to file as JSON atomically.
 * @function writeJSONAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param object The javascript object you would like to write to file
 * @param options The options to pass JSON.stringify and writeFile
 */
async function writeJSONAtomic(file, object, options = {}) {
    return writeJSON_1.writeJSON(file, object, options, true);
}
exports.writeJSONAtomic = writeJSONAtomic;
exports.writeJsonAtomic = writeJSONAtomic;
//# sourceMappingURL=writeJSONAtomic.js.map