"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeJson = exports.writeJSON = void 0;
const fs_1 = require("fs");
const writeFileAtomic_1 = require("./writeFileAtomic");
async function writeJSON(file, object, options = {}, atomic = false) {
    if (typeof options === 'boolean')
        [atomic, options] = [options, {}];
    const writeMethod = atomic ? writeFileAtomic_1.writeFileAtomic : fs_1.promises.writeFile;
    await writeMethod(file, `${JSON.stringify(object, options.replacer, options.spaces)}\n`, options);
}
exports.writeJSON = writeJSON;
exports.writeJson = writeJSON;
//# sourceMappingURL=writeJSON.js.map