import { BaseEncodingOptions } from './writeFileAtomic';
/**
 * @typedef {Object} JsonOptions
 * @memberof fsn/nextra
 * @property {Function} [replacer] A JSON.stringify replacer function
 * @property {number} [spaces = null] The number of spaces to format the json file with
 * @property {string} [encoding = 'utf8'] The file encoding
 * @property {number} [mode = 0o666] The chmod
 * @property {string} [flag = 'w'] The flag
 */
export interface JsonOptions {
    replacer?: (key: string, value: any) => any;
    spaces?: string | number;
    encoding?: BaseEncodingOptions;
    mode?: number;
    flag?: string;
}
/**
 * Writes a Javascript Object to file as JSON.
 * @function writeJson
 * @memberof fsn/nextra
 * @param {string} file The path to the file you want to create
 * @param {Object} object The javascript object you would like to write to file
 * @param {JsonOptions} [options = {}] The options to pass JSON.stringify and writeFile
 * @param {boolean} [atomic = false] Whether the operation should run atomically
 * @returns {Promise<void>}
 */
/**
 * Writes a Javascript Object to file as JSON.
 * @function writeJSON
 * @memberof fsn/nextra
 * @param {string} file The path to the file you want to create
 * @param {Object} object The javascript object you would like to write to file
 * @param {JsonOptions} [options = {}] The options to pass JSON.stringify and writeFile
 * @param {boolean} [atomic = false] Whether the operation should run atomically
 * @returns {Promise<void>}
 */
export declare function writeJSON(file: string, object: any, atomic?: boolean): Promise<void>;
export declare function writeJSON(file: string, object: any, options?: JsonOptions, atomic?: boolean): Promise<void>;
export declare const writeJson: typeof writeJSON;
