"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeFileAtomic = void 0;
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const move_1 = require("./move");
/**
 * @function writeFileAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param data The data to write to file
 * @param options The write options or the encoding string.
 */
async function writeFileAtomic(file, data, options) {
    const tempPath = util_1.tempFile();
    await fs_1.promises.writeFile(tempPath, data, options);
    await move_1.move(tempPath, file, { overwrite: true });
}
exports.writeFileAtomic = writeFileAtomic;
//# sourceMappingURL=writeFileAtomic.js.map