"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unTargz = void 0;
const zlib_1 = require("zlib");
const path_1 = require("path");
const fs_1 = require("fs");
const Untar_1 = require("../utils/Untar");
const outputFile_1 = require("./outputFile");
const outputFileAtomic_1 = require("./outputFileAtomic");
/**
 * Extracts files from .tar.gz archives.
 * @function unTargz
 * @memberof fsn/nextra
 * @param outputDirectory The directory to extract to
 * @param inputFile The archive file
 * @param atomic The if the writes should be atomic
 */
async function unTargz(outputDirectory, inputFile, atomic = false) {
    const tar = fs_1.createReadStream(inputFile).pipe(zlib_1.createGunzip()).pipe(new Untar_1.Untar());
    const writeMethod = atomic ? outputFile_1.outputFile : outputFileAtomic_1.outputFileAtomic;
    for await (const { header, file } of tar.files())
        await writeMethod(path_1.resolve(outputDirectory, header.filename), file);
}
exports.unTargz = unTargz;
//# sourceMappingURL=unTargz.js.map