"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.targzAtomic = void 0;
const targz_1 = require("./targz");
const move_1 = require("./move");
const util_1 = require("../utils/util");
/**
 * Tar/Gzips a directory or array of files.
 * @function targzAtomic
 * @memberof fsn/nextra
 * @param fileName The filename of the archive
 * @param inputFiles The directory or array of filepaths to .tar.gz
 */
async function targzAtomic(fileName, inputFiles) {
    const tempPath = util_1.tempFile();
    await targz_1.targz(tempPath, inputFiles);
    return move_1.move(tempPath, fileName, { overwrite: true });
}
exports.targzAtomic = targzAtomic;
//# sourceMappingURL=targzAtomic.js.map