"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.targz = void 0;
const zlib_1 = require("zlib");
const fs_1 = require("fs");
const path_1 = require("path");
const Tar_1 = require("../utils/Tar");
const util_1 = require("../utils/util");
const scan_1 = require("./scan");
const targzAtomic_1 = require("./targzAtomic");
/**
 * Tar/Gzips a directory or array of files.
 * @function targz
 * @memberof fsn/nextra
 * @param fileName The filename of the archive
 * @param inputFiles The directory or array of filepaths to .tar.gz
 * @param options The options for this .tar.gz
 */
async function targz(fileName, inputFiles, atomic = false) {
    if (atomic)
        return targzAtomic_1.targzAtomic(fileName, inputFiles);
    if (!Array.isArray(inputFiles))
        inputFiles = [inputFiles];
    const tar = new Tar_1.Tar(path_1.dirname(inputFiles[0]));
    for (const input of inputFiles) {
        const stats = await fs_1.promises.lstat(input);
        if (stats.isDirectory()) {
            const files = await scan_1.scan(input, { filter: (dirent) => dirent.isFile() });
            for (const file of files.keys())
                tar.append(file, await fs_1.promises.lstat(file));
        }
        else {
            tar.append(input, stats);
        }
    }
    return util_1.pipelinePromise(tar, zlib_1.createGzip(), fs_1.createWriteStream(fileName));
}
exports.targz = targz;
//# sourceMappingURL=targz.js.map