"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.symlinkAtomic = void 0;
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const move_1 = require("./move");
/**
 * Creates a soft file link atomically.
 * @function symlinkAtomic
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param type The type of symlink you are creating
 */
async function symlinkAtomic(source, destination, type) {
    const tempPath = util_1.tempFile();
    await fs_1.promises.symlink(source, tempPath, type);
    await move_1.move(tempPath, destination, { overwrite: false });
}
exports.symlinkAtomic = symlinkAtomic;
//# sourceMappingURL=symlinkAtomic.js.map