"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scan = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
/**
 * Recursively scans a directory, returning a map of stats keyed on the full path to the item.
 * @function scan
 * @memberof fsn/nextra
 * @param root The path to scan
 * @param options The options for the scan
 */
function scan(root, options = {}) {
    return scanDeep(path_1.resolve(root), new Map(), 0, options);
}
exports.scan = scan;
async function scanDeep(path, results, level, options) {
    const dir = await fs_1.promises.opendir(path);
    for await (const dirent of dir) {
        const fullPath = path_1.join(path, dirent.name);
        if (!options.filter || options.filter(dirent, fullPath))
            results.set(fullPath, dirent);
        if (dirent.isDirectory() && (typeof options.depthLimit === 'undefined' || level < options.depthLimit)) {
            await scanDeep(path_1.join(path, dirent.name), results, level + 1, options);
        }
    }
    return results;
}
//# sourceMappingURL=scan.js.map