/// <reference types="node" />
import { Dirent } from 'fs';
/**
 * @typedef {Object} ScanOptions
 * @memberof fsn/nextra
 * @property {Function} [filter] A filter function receiving (dirent, path) to determine if the returned map should include a given entry
 * @property {number} [depthLimit] How many directories deep the scan should go (0 is just the children of the passed root directory, no subdirectory files)
 */
export interface ScanOptions {
    filter?: (dirent: Dirent, path: string) => boolean;
    depthLimit?: number;
}
/**
 * Recursively scans a directory, returning a map of stats keyed on the full path to the item.
 * @function scan
 * @memberof fsn/nextra
 * @param root The path to scan
 * @param options The options for the scan
 */
export declare function scan(root: string, options?: ScanOptions): Promise<Map<string, Dirent>>;
