/**
 * @typedef {Object} RemoveOptions
 * @memberof fsn/nextra
 * @property {number} [maxBusyTries = 3] The number of times fs-nextra should retry removing a busy file.
 */
export interface RemoveOptions {
    maxBusyTries?: number;
}
/**
 * Recursively deletes directories and files.
 * @function remove
 * @memberof fsn/nextra
 * @param path The path to remove
 * @param options The remove options
 */
export declare function remove(path: string, options?: RemoveOptions): Promise<void>;
