"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readJson = exports.readJSON = void 0;
const fs_1 = require("fs");
/**
 * Reads a file and parses it into a javascript object.
 * @function readJson
 * @memberof fsn/nextra
 * @param {string} file The file path to the json file
 * @param {ReadJSONOptions|string} [options = {}] The options for reading json or the encoding string
 * @returns {Promise<Object>}
 */
/**
 * Reads a file and parses it into a javascript object.
 * @function readJSON
 * @memberof fsn/nextra
 * @param {string} file The file path to the json file
 * @param {ReadJSONOptions|string} [options = {}] The options for reading json or the encoding string
 * @returns {Promise<Object>}
 */
async function readJSON(file, options = { flag: 'r' }) {
    if (typeof options === 'string')
        options = { encoding: options, flag: 'r' };
    const content = await fs_1.promises.readFile(file, options);
    return JSON.parse(stripBom(content), options.reviver);
}
exports.readJSON = readJSON;
function stripBom(content) {
    if (Buffer.isBuffer(content))
        content = content.toString('utf8');
    return content.replace(/^\uFEFF/, '');
}
exports.readJson = readJSON;
//# sourceMappingURL=readJSON.js.map