"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pathExists = void 0;
const fs_1 = require("fs");
/**
 * Checks if a path exists.
 * @function pathExists
 * @memberof fsn/nextra
 * @param path The path to check
 */
async function pathExists(path) {
    try {
        await fs_1.promises.access(path);
        return true;
    }
    catch (err) {
        return false;
    }
}
exports.pathExists = pathExists;
//# sourceMappingURL=pathExists.js.map