"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputJsonAtomic = exports.outputJSONAtomic = void 0;
const outputJSON_1 = require("./outputJSON");
/**
 * Writes a json file to disk, creating all directories needed to meet the filepath provided atomically.
 * @function outputJsonAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param data The data to write to file
 * @param options The write options or the encoding string.
 */
/**
 * Writes a json file to disk, creating all directories needed to meet the filepath provided atomically.
 * @function outputJSONAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param data The data to write to file
 * @param options The write options or the encoding string.
 */
function outputJSONAtomic(file, data, options) {
    return outputJSON_1.outputJSON(file, data, options, true);
}
exports.outputJSONAtomic = outputJSONAtomic;
exports.outputJsonAtomic = outputJSONAtomic;
//# sourceMappingURL=outputJSONAtomic.js.map