"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputJson = exports.outputJSON = void 0;
const path_1 = require("path");
const writeJSON_1 = require("./writeJSON");
const mkdirs_1 = require("./mkdirs");
async function outputJSON(file, data, options, atomic = false) {
    if (typeof options === 'boolean')
        [atomic, options] = [options, {}];
    await mkdirs_1.mkdirs(path_1.dirname(file));
    return writeJSON_1.writeJSON(file, data, options, atomic);
}
exports.outputJSON = outputJSON;
exports.outputJson = outputJSON;
//# sourceMappingURL=outputJSON.js.map