"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFileAtomic = void 0;
const outputFile_1 = require("./outputFile");
/**
 * Writes a file to disk, creating all directories needed to meet the filepath provided atomically.
 * @function outputFileAtomic
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param data The data to write to file
 * @param options The write options or the encoding string.
 * @returns {Promise<void>}
 */
function outputFileAtomic(file, data, options) {
    return outputFile_1.outputFile(file, data, options, true);
}
exports.outputFileAtomic = outputFileAtomic;
//# sourceMappingURL=outputFileAtomic.js.map