"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFile = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const writeFileAtomic_1 = require("./writeFileAtomic");
const mkdirs_1 = require("./mkdirs");
async function outputFile(file, data, options, atomic = false) {
    if (typeof options === 'boolean')
        [atomic, options] = [options, {}];
    await mkdirs_1.mkdirs(path_1.dirname(file));
    const writeMethod = atomic ? writeFileAtomic_1.writeFileAtomic : fs_1.promises.writeFile;
    await writeMethod(file, data, options);
}
exports.outputFile = outputFile;
//# sourceMappingURL=outputFile.js.map