/// <reference types="node" />
import { WriteOptions, BaseEncodingOptions } from './writeFileAtomic';
/**
 * Writes a file to disk, creating all directories needed to meet the filepath provided.
 * @function outputFile
 * @memberof fsn/nextra
 * @param file The path to the file you want to create
 * @param data The data to write to file
 * @param options The write options or the encoding string.
 * @param atomic {description}
 */
export declare function outputFile(file: string, data: string | Buffer | Uint8Array, atomic?: boolean): Promise<void>;
export declare function outputFile(file: string, data: string | Buffer | Uint8Array, options?: WriteOptions | BaseEncodingOptions, atomic?: boolean): Promise<void>;
