/**
 * @typedef {Object} MoveOptions
 * @memberof fsn/nextra
 * @property {boolean} [overwrite = false] Should the move overwrite an identical file at the destination path
 */
export interface MoveOptions {
    overwrite?: boolean;
}
/**
 * @function move
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param options The options for the move
 */
export declare function move(source: string, destination: string, options?: MoveOptions): Promise<void>;
