"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureDir = exports.mkdirp = exports.mkdirs = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const util_1 = require("../utils/util");
/**
 * Recursively makes directories, until the directory passed exists.
 * @function ensureDir
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
/**
 * Recursively makes directories, until the directory passed exists.
 * @function mkdirp
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
/**
 * Recursively makes directories, until the directory passed exists.
 * @function mkdirs
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
async function mkdirs(path, options) {
    const dirOptions = resolveOptions(options);
    if (util_1.isWindows && util_1.invalidWin32Path(path)) {
        const errInval = new Error(`FS-NEXTRA: ${path} contains invalid WIN32 path characters.`);
        // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore
        errInval.code = 'EINVAL';
        throw errInval;
    }
    path = path_1.resolve(path);
    try {
        await fs_1.promises.mkdir(path, dirOptions.mode);
    }
    catch (err) {
        if (err.code === 'ENOENT') {
            await mkdirs(path_1.dirname(path), dirOptions);
            await mkdirs(path, dirOptions);
            return;
        }
        const myStat = await fs_1.promises.stat(path);
        if (myStat.isDirectory())
            return;
        throw err;
    }
}
exports.mkdirs = mkdirs;
function resolveOptions(options = {}) {
    return {
        // eslint-disable-next-line no-bitwise
        mode: typeof options === 'number' ? options : options.mode || 0o0777 & ~util_1.umask
    };
}
exports.mkdirp = mkdirs;
exports.ensureDir = mkdirs;
//# sourceMappingURL=mkdirs.js.map