/**
 * @typedef {Object} MkdirsOptions
 * @memberof fsn/nextra
 * @property {number} [mode = 0o777 & ~process.umask()] The chmod for the directories being made
 */
export interface MkdirsOptions {
    mode?: number;
}
/**
 * Recursively makes directories, until the directory passed exists.
 * @function ensureDir
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
/**
 * Recursively makes directories, until the directory passed exists.
 * @function mkdirp
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
/**
 * Recursively makes directories, until the directory passed exists.
 * @function mkdirs
 * @memberof fsn/nextra
 * @param path The path you wish to make
 * @param options Options for making the directories
 */
export declare function mkdirs(path: string, options?: MkdirsOptions | number): Promise<void>;
export declare const mkdirp: typeof mkdirs;
export declare const ensureDir: typeof mkdirs;
